/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions;

import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.tsmodel.application.actions.DeletionAction;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class PBDeletionAction
implements IElementMultiAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final String NAME;
    private static final String INFO;
    private static final String DESCRIPTION;
    private static final Image IMAGE;
    private static final ICategory CATEGORY;
    private DeletionAction mDeletionAction = null;
    private static Set sSaveRelevantSubdomains;

    public PBDeletionAction() {
        sSaveRelevantSubdomains.add("Application");
        sSaveRelevantSubdomains.add("Component");
        sSaveRelevantSubdomains.add("Window");
        sSaveRelevantSubdomains.add("ComponentInterfaceDefinition");
        sSaveRelevantSubdomains.add("InterfaceViewDefinition");
        sSaveRelevantSubdomains.add("Model");
        sSaveRelevantSubdomains.add("ModelClass");
        this.mDeletionAction = new DeletionAction();
    }

    public ICategory getCategory() {
        return CATEGORY;
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            boolean enable;
            String subdomain = elements[i].getUniqueName().getSubDomain();
            boolean bl = enable = subdomain.equals("Model") || subdomain.equals("ModelClass") || subdomain.equals("TargetRole") || subdomain.equals("Application") || subdomain.equals("Component") || subdomain.equals("CustomController") || subdomain.equals("Window") || subdomain.equals("Viewset") || subdomain.equals("ViewUsage") || subdomain.equals("View") || subdomain.equals("OutboundPlugUsage") || subdomain.equals("InboundPlugUsage") || subdomain.equals("NavigationLink") || subdomain.equals("ComponentUsage") || subdomain.equals("ComponentInterfaceDefinition") || subdomain.equals("InterfaceViewDefinition") || subdomain.equals("ModelUsage") || subdomain.equals("ImplementedInterface") || subdomain.equals("CIDModelUsage") || subdomain.equals("ModelModelUsage") || subdomain.equals("DataLink") || subdomain.equals("LogConfiguration") || subdomain.equals("ViewContainerAssignment");
            if (!enable) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                boolean enable = this.mDeletionAction.isEnabled((Entity)elements[i]);
                if (!enable) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                this.mDeletionAction.setSelectedEntity((Entity)elements[i]);
                this.mDeletionAction.run((IAction)null);
                this.save(elements[i]);
            }
            ++i;
        }
    }

    private void save(Element element) {
        String subdomain = element.getUniqueName().getSubDomain();
        if (sSaveRelevantSubdomains.contains(subdomain)) {
            String projectName = element.getModel().getUniqueName().getName();
            MetamodelManager.saveAllMetaData((String)projectName);
        }
    }

    public void run(Element element) {
        Element[] elements = new Element[]{element};
        this.run(elements);
    }

    public boolean isAvailable(Element element) {
        Element[] elements = new Element[]{element};
        return this.isAvailable(elements);
    }

    static {
        INFO = NAME = mText.getText(106);
        DESCRIPTION = mText.getText(206);
        IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE_HOVER");
        CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainMetamodelCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)IMAGE);
        sSaveRelevantSubdomains = new HashSet();
    }
}

