/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions;

import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.tsmodel.application.actions.DeletionAction;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;

public class PBDeleteProjectAction
implements IElementMultiAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final CoreTextPool mCText = CoreTextPool.getInstance();
    private static final String PROJECT = mCText.getText(303);
    private static final String NAME;
    private static final String INFO;
    private static final String DESCRIPTION;
    private static final Image IMAGE;
    private static final ICategory CATEGORY;
    private DeletionAction mDeletionAction = new DeletionAction();

    public ICategory getCategory() {
        return CATEGORY;
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String projectName = elements[i].getModel().getUniqueName().getName();
                if (ServicesEclipse.projectHasComponentNature((String)projectName)) {
                    return false;
                }
                String subdomain = elements[i].getUniqueName().getSubDomain();
                if (!subdomain.equals("project")) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String projectName = elements[i].getModel().getUniqueName().getName();
                if (ServicesEclipse.projectHasComponentNature((String)projectName)) {
                    return false;
                }
                boolean enable = this.mDeletionAction.isEnabled((Entity)elements[i]);
                if (!enable) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        Vector<IProject> selectedProjects = new Vector<IProject>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                Entity entity = (Entity)elements[i];
                String projectName = entity.getUniqueName().getName();
                IProject project = workspaceRoot.getProject(projectName);
                selectedProjects.add(project);
            }
            ++i;
        }
        Object[] projects = selectedProjects.toArray(new IProject[0]);
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = workbenchWindow.getShell();
        DeleteResourceAction action = new DeleteResourceAction(shell);
        StructuredSelection structuredSelection = new StructuredSelection(projects);
        action.selectionChanged((IStructuredSelection)structuredSelection);
        action.run();
    }

    public void run(Element element) {
        Element[] elements = new Element[]{element};
        this.run(elements);
    }

    static {
        INFO = NAME = mText.getText(106);
        DESCRIPTION = mText.getText(214);
        IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE_HOVER");
        CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)IMAGE);
    }
}

