/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.webdynpro.projectbrowser.ProjectBrowserPlugin;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.tsmodel.application.actions.CreateComponentAction;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PBCreateComponentAction
implements IElementSingleAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final CoreTextPool mCText = CoreTextPool.getInstance();
    private static final String COMPONENT = mCText.getText(111);
    private static final String NAME;
    private static final String INFO;
    private static final String DESCRIPTION;
    private static final Image IMAGE;
    private final ICategory CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainMetamodelCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)IMAGE);
    private CreateComponentAction mComponentAction = new CreateComponentAction();

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    public boolean isAvailable(Element element) {
        String subdomain;
        return element instanceof Entity && element != null && (subdomain = element.getUniqueName().getSubDomain()).equals("Components");
    }

    public boolean isEnabled(Element element) {
        if (element instanceof Entity && element != null) {
            return this.mComponentAction.isEnabled((Entity)element);
        }
        return false;
    }

    public void run(Element element) {
        try {
            if (!(element instanceof Entity) || element == null) {
                return;
            }
            this.mComponentAction.setSelectedEntity((Entity)element);
            this.mComponentAction.run(null);
            Entity componentEntity = this.mComponentAction.getCreatedEntity();
            if (componentEntity == null) {
                return;
            }
            String subdomain = componentEntity.getUniqueName().getSubDomain();
            if (!subdomain.equals("Component")) {
                ProjectBrowserPlugin.internalError(this.getClass(), "run", "wrong subdomain", null, false);
                return;
            }
            DataSourceManager manager = DataSourceManager.getDataSourceManager((String)componentEntity.getModel().getUniqueName().getName());
            DevelopmentObject developmentObject = manager.getDevelopmentObject(componentEntity.getUniqueName());
            if (!(developmentObject instanceof Component)) {
                ProjectBrowserPlugin.internalError(this.getClass(), "run", "developmentObject is no Component " + developmentObject.getKey().toString(), null, false);
                return;
            }
            Component component = (Component)developmentObject;
            PBCreateComponentAction.saveAndOpenDiagrams(component, componentEntity);
        }
        catch (Throwable t) {
            ProjectBrowserPlugin.internalError(this.getClass(), "run", "run failed ", t, false);
        }
    }

    public static void saveAndOpenDiagrams(Component component, Entity componentEntity) {
        Entity windowEntity = null;
        if (!component.originatesInArchive()) {
            Utils.forceDiagramFileCreation((Entity)componentEntity);
            Window[] windows = component.getWindows();
            if (windows != null && windows.length >= 0) {
                windowEntity = Utils.getEntity((DevelopmentObject)windows[0], (String)"Window");
                Utils.forceDiagramFileCreation((Entity)windowEntity);
            }
        }
        final Metamodel lMetamodel = component.getMetamodel();
        final Entity lComponentEntity = componentEntity;
        final Entity lWindowEntity = windowEntity;
        final Component lComponent = component;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MetamodelManager.saveAllMetaData((Metamodel)lMetamodel);
                if (!lComponent.originatesInArchive()) {
                    Utils.openDiagram((Element)lComponentEntity);
                    if (lWindowEntity != null) {
                        Utils.openDiagram((Element)lWindowEntity);
                    }
                }
            }
        });
    }

    static {
        INFO = NAME = mText.getText(104, COMPONENT);
        DESCRIPTION = mText.getText(204, COMPONENT);
        IMAGE = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_COMPONENT);
    }
}

