/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions;

import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.webdynpro.projectbrowser.ProjectBrowserPlugin;
import com.sap.ide.webdynpro.projectbrowser.actions.PBCreateComponentAction;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.tsmodel.application.actions.CreateApplicationAction;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.IActionContext;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.swt.graphics.Image;

public class PBCreateApplicationAction
implements IElementSingleAction {
    private static final TextPool mText = TextPool.getInstance();
    private static final CoreTextPool mCText = CoreTextPool.getInstance();
    private static final String APPLICATION = mCText.getText(126);
    private static final String NAME;
    private static final String INFO;
    private static final Image IMAGE;
    private static final String DESCRIPTION;
    private static final ICategory CATEGORY;
    private CreateApplicationAction mApplicationAction = new CreateApplicationAction();

    public void run(IActionContext actionContext) {
        Object object = actionContext.getActionObject();
        if (object instanceof Entity) {
            this.mApplicationAction.setSelectedEntity((Entity)object);
            this.mApplicationAction.run(null);
        }
    }

    public ICategory getCategory() {
        return CATEGORY;
    }

    public boolean isAvailable(Element element) {
        String subdomain;
        return element instanceof Entity && element != null && (subdomain = element.getUniqueName().getSubDomain()).equals("Applications");
    }

    public boolean isEnabled(Element element) {
        if (element instanceof Entity && element != null) {
            return this.mApplicationAction.isEnabled((Entity)element);
        }
        return false;
    }

    public void run(Element element) {
        try {
            if (element instanceof Entity && element != null) {
                this.mApplicationAction.setSelectedEntity((Entity)element);
                this.mApplicationAction.run(null);
                Entity createdEntity = this.mApplicationAction.getCreatedEntity();
                if (createdEntity != null) {
                    DataSourceManager manager = DataSourceManager.getDataSourceManager((String)createdEntity.getModel().getUniqueName().getName());
                    DevelopmentObject developmentObject = manager.getDevelopmentObject(createdEntity.getUniqueName());
                    if (developmentObject instanceof Application) {
                        Component component = ((Application)developmentObject).getComponent();
                        if (component != null) {
                            UniqueName componentUniqueName = DataSourceManager.createUniqueName((DevelopmentObject)component, (String)"Component");
                            String projectName = component.getRoot().getMetamodel().getName();
                            UniqueName modelUIN = ModelAccess.createModelUniqueName((String)projectName);
                            Model model = ModelAccess.getModel((UniqueName)modelUIN);
                            if (model == null) {
                                ProjectBrowserPlugin.internalError(this.getClass(), "run", "could not find Model " + modelUIN.toString(), null, false);
                                return;
                            }
                            Entity componentEntity = model.findEntity(componentUniqueName);
                            PBCreateComponentAction.saveAndOpenDiagrams(component, componentEntity);
                        }
                    } else {
                        ProjectBrowserPlugin.internalError(this.getClass(), "run", "developmentObject is no Application " + developmentObject.getKey().toString(), null, false);
                    }
                }
            }
        }
        catch (Throwable t) {
            ProjectBrowserPlugin.internalError(this.getClass(), "run", "run failed ", t, false);
        }
    }

    static {
        INFO = NAME = mText.getText(104, APPLICATION);
        IMAGE = SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_APPLICATION);
        DESCRIPTION = mText.getText(204, APPLICATION);
        CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainMetamodelCategory(), (String)DESCRIPTION, (String)NAME, (String)INFO, (Image)IMAGE);
    }
}

