/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions;

import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.core.services.MetamodelImage;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;

public class PBCheckoutDataViewAction
implements IElementSingleAction {
    private final TextPool mText = TextPool.getInstance();
    private final String NAME;
    private final String INFO = this.NAME = this.mText.getText(138);
    private final String DESCRIPTION = this.mText.getText(233);
    private final Image IMAGE = SapIdeUtilImages.getSapImage((ISapImage)MetamodelImage.ICON_CHECKOUT_FROM_DTR);
    private final ICategory CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainDtrCategory(), (String)this.DESCRIPTION, (String)this.NAME, (String)this.INFO, (Image)this.IMAGE);

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    public boolean isAvailable(Element element) {
        if (!(element instanceof Entity)) {
            return false;
        }
        if (!element.getUniqueName().getSubDomain().equals("Component")) {
            return false;
        }
        UniqueName modelUIN = element.getModel().getUniqueName();
        if (!SelenaElementUtil.isProjectModelUniqueName((UniqueName)modelUIN)) {
            return false;
        }
        String projectName = modelUIN.getName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return false;
        }
        if (!DtrHelper.isUserLoggedOn((IProject)project)) {
            return false;
        }
        return DtrHelper.isProjectUnderSourceControl((IProject)project);
    }

    public boolean isEnabled(Element element) {
        if (!(element instanceof Entity)) {
            return false;
        }
        String projectName = element.getModel().getUniqueName().getName();
        DataSourceManager dataSourceManager = DataSourceManager.getDataSourceManager((String)projectName);
        Component component = (Component)dataSourceManager.getDevelopmentObject(element.getUniqueName());
        IPath path = Utils.getDiagramFilePath((MainDevelopmentObject)component);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFile file = project.getFile(path);
        return file.exists() && file.isReadOnly();
    }

    public void run(Element element) {
        if (!(element instanceof Entity)) {
            return;
        }
        String projectName = element.getModel().getUniqueName().getName();
        DataSourceManager dataSourceManager = DataSourceManager.getDataSourceManager((String)projectName);
        Component component = (Component)dataSourceManager.getDevelopmentObject(element.getUniqueName());
        MMRepositoryObject repositoryObject = new MMRepositoryObject(component.getRoot().getMetamodel(), "Data Modeler diagram", "", false);
        IPath path = Utils.getDiagramFilePath((MainDevelopmentObject)component);
        repositoryObject.addAdditionalFile(path);
        MMRepositoryObjectList repositoryObjectList = new MMRepositoryObjectList();
        repositoryObjectList.addRepositoryObject(repositoryObject);
        RepositoryServices.checkout((MMRepositoryObject[])repositoryObjectList.getRepositoryObjects());
    }
}

