/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.projectbrowser.actions;

import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.core.services.MetamodelImage;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.repository.MMRepositoryObjectProvider;
import com.sap.ide.webdynpro.projectbrowser.services.ServicesProjectBrowser;
import com.sap.ide.webdynpro.projectbrowser.services.TextPool;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.graphics.Image;

public class PBCheckoutAction
implements IElementMultiAction {
    private final TextPool mText = TextPool.getInstance();
    private final CoreTextPool mCText = CoreTextPool.getInstance();
    private final String NAME;
    private final String INFO = this.NAME = this.mText.getText(109);
    private final String DESCRIPTION = this.mText.getText(232);
    private final Image IMAGE = SapIdeUtilImages.getSapImage((ISapImage)MetamodelImage.ICON_CHECKOUT_FROM_DTR);
    private final ICategory CATEGORY = Category.createDisplayableCategory((ICategory)ActionCategories.getMainDtrCategory(), (String)this.DESCRIPTION, (String)this.NAME, (String)this.INFO, (Image)this.IMAGE);

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        IProject theProject = null;
        int i = 0;
        while (i < elements.length) {
            Element element = elements[i];
            UniqueName modelUIN = element.getModel().getUniqueName();
            if (SelenaElementUtil.isProjectModelUniqueName((UniqueName)modelUIN)) {
                String projectName = modelUIN.getName();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project == null) {
                    return false;
                }
                if (!DtrHelper.isUserLoggedOn((IProject)project)) {
                    return false;
                }
                if (!DtrHelper.isProjectUnderSourceControl((IProject)project)) {
                    return false;
                }
                if (theProject == null) {
                    theProject = project;
                } else if (theProject != project) {
                    return false;
                }
            }
            ++i;
        }
        return ServicesProjectBrowser.elementsBelongToValidProject(elements);
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        MMRepositoryObjectList repositoryObjectList = this.getRepositoryObjects(elements);
        boolean enabled = RepositoryServices.containsReadonlyFiles((MMRepositoryObject[])repositoryObjectList.getRepositoryObjects());
        return enabled;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        MMRepositoryObjectList repositoryObjectList = this.getRepositoryObjects(elements);
        RepositoryServices.checkout((MMRepositoryObject[])repositoryObjectList.getRepositoryObjects());
    }

    private MMRepositoryObjectList getRepositoryObjects(Element[] elements) {
        MMRepositoryObjectList repositoryObjectList = new MMRepositoryObjectList();
        int i = 0;
        while (i < elements.length) {
            MainDevelopmentObject mdo;
            Entity entity;
            String projectName;
            DataSourceManager dataSourceManager;
            if (elements[i] instanceof Entity && (dataSourceManager = DataSourceManager.getDataSourceManager((String)(projectName = (entity = (Entity)elements[i]).getModel().getUniqueName().getName()))) != null && (mdo = (MainDevelopmentObject)dataSourceManager.findDevelopmentObject(entity.getUniqueName())) != null) {
                MMRepositoryObject repositoryObject = MMRepositoryObjectProvider.getInstance().getRepositoryObject(mdo, false);
                repositoryObjectList.addRepositoryObject(repositoryObject);
            }
            ++i;
        }
        return repositoryObjectList;
    }
}

