/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tomcat.internal;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.http.HttpConnector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.Embedded;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.appserver.IWebappServer;
import org.eclipse.tomcat.internal.LocalConnectionTest;
import org.eclipse.tomcat.internal.PortTrackingServerSocketFactory;
import org.eclipse.tomcat.internal.TomcatPlugin;
import org.eclipse.tomcat.internal.TomcatResources;
import org.eclipse.tomcat.internal.WebAppClassLoader;

public class TomcatAppServer
implements IWebappServer {
    private String hostAddress;
    private int port;
    private boolean isStarted = false;
    private boolean running = false;
    private Embedded embedded = null;
    private Engine engine = null;
    private Host host = null;

    public void start(int port, String hostAddress) throws CoreException {
        this.hostAddress = hostAddress;
        this.port = port;
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        try {
            FileLogger logger = new FileLogger();
            logger.setDirectory(TomcatPlugin.getDefault().getStateLocation().toOSString());
            this.embedded = new Embedded((Logger)logger, (Realm)new MemoryRealm());
            this.embedded.setDebug(0);
            this.embedded.setLogger((Logger)logger);
            IPluginDescriptor descriptor = TomcatPlugin.getDefault().getDescriptor();
            URL installURL = descriptor.getInstallURL();
            String home = Platform.resolve((URL)installURL).getFile();
            System.setProperty("catalina.home", home);
            String base = home;
            System.setProperty("catalina.base", base);
            this.embedded.start();
            this.engine = this.embedded.createEngine();
            this.engine.setDefaultHost("localhost");
            this.host = this.embedded.createHost("localhost", String.valueOf(home) + "/webapps");
            if (this.host instanceof StandardHost) {
                ((StandardHost)this.host).setErrorReportValveClass("org.eclipse.tomcat.internal.EclipseErrorReportValve");
            }
            this.engine.addChild((Container)this.host);
            PrintStream sysOut = System.out;
            System.setOut(new PrintStream(new ByteArrayOutputStream()));
            try {
                this.embedded.addEngine(this.engine);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                System.setOut(sysOut);
                throw throwable;
            }
            Object var9_13 = null;
            System.setOut(sysOut);
            Context root = this.embedded.createContext("", String.valueOf(home) + "/webapps/ROOT");
            if (root instanceof StandardContext) {
                ((StandardContext)root).setWorkDir(this.getWorkingDirectory("ROOT"));
            }
            root.setLoader(this.embedded.createLoader(this.getClass().getClassLoader()));
            this.host.addChild((Container)root);
            InetAddress iAddress = null;
            if (this.hostAddress != null) {
                try {
                    iAddress = InetAddress.getByName(this.hostAddress);
                }
                catch (UnknownHostException unknownHostException) {}
            }
            Connector connector = this.embedded.createConnector(iAddress, this.port, false);
            PortTrackingServerSocketFactory sSocketFactory = new PortTrackingServerSocketFactory();
            connector.setFactory((ServerSocketFactory)sSocketFactory);
            if (connector instanceof HttpConnector) {
                int minProcessors;
                int maxProcessors;
                HttpConnector httpConnector = (HttpConnector)connector;
                Preferences pref = TomcatPlugin.getDefault().getPluginPreferences();
                int acceptCount = pref.getInt("acceptCount");
                if (acceptCount > 0) {
                    httpConnector.setAcceptCount(acceptCount);
                }
                if ((maxProcessors = pref.getInt("maxProcessors")) > 0) {
                    httpConnector.setMaxProcessors(maxProcessors);
                }
                if ((minProcessors = pref.getInt("minProcessors")) > 0) {
                    httpConnector.setMinProcessors(minProcessors);
                }
            }
            this.embedded.addConnector(connector);
            this.port = sSocketFactory.getAssignedPort();
            if (this.port == 0) {
                if (port == 0) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.start.CannotOptainPort"), null));
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.start.CannotOpenPort", "" + port), null));
            }
            if (this.hostAddress == null) {
                this.hostAddress = LocalConnectionTest.getLocalInterface(this.port);
            }
            this.running = true;
        }
        catch (Exception exc) {
            TomcatPlugin.logError(TomcatResources.getString("TomcatAppServer.start"), exc);
            if (exc instanceof CoreException) {
                throw (CoreException)exc;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.start"), (Throwable)exc));
        }
    }

    public void start(String webappName, IPath path, ClassLoader customLoader) throws CoreException {
        if (!this.isStarted) {
            this.start(this.port, this.hostAddress);
        }
        if (!this.running) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.addingWebapp", webappName, path.toOSString()), null));
        }
        String contextPath = webappName;
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        try {
            Context context = this.embedded.createContext(contextPath, path.toOSString());
            if (context instanceof StandardContext) {
                ((StandardContext)context).setWorkDir(this.getWorkingDirectory(webappName));
            }
            WebAppClassLoader webappLoader = new WebAppClassLoader(customLoader);
            context.setLoader(this.embedded.createLoader((ClassLoader)webappLoader));
            this.host.addChild((Container)context);
        }
        catch (Exception exc) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.addingWebapp", webappName, path.toOSString()), (Throwable)exc));
        }
    }

    public void stop(String webappName) throws CoreException {
        if (!this.running) {
            return;
        }
        Context context = (Context)this.host.findChild("/" + webappName);
        if (context != null) {
            this.embedded.removeContext(context);
        }
    }

    public String getHost() {
        if (!this.running) {
            return null;
        }
        return this.hostAddress;
    }

    public int getPort() {
        if (!this.running) {
            return 0;
        }
        return this.port;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() throws CoreException {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.embedded.removeEngine(this.engine);
        }
        catch (Exception exc) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.engineRemove"), (Throwable)exc));
        }
        try {
            this.embedded.stop();
        }
        catch (LifecycleException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.tomcat", 0, TomcatResources.getString("TomcatAppServer.embeddedStop"), (Throwable)e));
        }
    }

    private String getWorkingDirectory(String webApp) {
        return TomcatPlugin.getDefault().getStateLocation().append(webApp).toOSString();
    }
}

