/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tomcat.internal;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.apache.jasper.compiler.JavaCompiler;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

public class JdtJasperCompiler
implements JavaCompiler {
    private static final String JDT_COMPILER_CLASS = "org.eclipse.jdt.internal.compiler.batch.Main";
    private static final String JDT_CORE_PLUGIN = "org.eclipse.jdt.core";
    private static Class jdtCompiler = null;
    private static Method compileMethod = null;
    private String outputDir;
    boolean classDebugInfo;
    private String classpath;
    private String encoding;
    private OutputStream os;
    private PrintWriter writer;
    private StringBuffer arguments = new StringBuffer();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean compile(String java) {
        String src = this.arg(java);
        if (src == null || src.trim().equals("")) {
            this.log("JDT Compiler: source file not specified");
            return false;
        }
        if (this.outputDir != null && !this.outputDir.trim().equals("")) {
            this.arguments.append(" -d ");
            this.arguments.append(this.arg(this.outputDir));
        }
        if (this.classpath != null && !this.classpath.trim().equals("")) {
            this.arguments.append(" -classpath ");
            this.arguments.append(this.classpath);
        }
        if (this.classDebugInfo) {
            this.arguments.append(" -g");
        }
        this.arguments.append(" ");
        this.arguments.append(src);
        try {
            return this.doCompile();
        }
        catch (Exception e) {
            this.log("JDT Compiler: " + e.toString());
            return false;
        }
    }

    public void setClassDebugInfo(boolean classDebugInfo) {
        this.classDebugInfo = classDebugInfo;
    }

    public void setClasspath(String classpath) {
        this.classpath = "";
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            this.classpath = String.valueOf(this.classpath) + "\"" + s + "\"" + File.pathSeparator;
        }
        String rtJar = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "rt.jar";
        this.classpath = String.valueOf(this.classpath) + "\"" + rtJar + "\"";
    }

    public void setCompilerPath(String compilerpath) {
    }

    public void setEncoding(String encoding) {
        this.encoding = this.arg(encoding);
    }

    public void setMsgOutput(OutputStream os) {
        this.os = os;
        if (os != null) {
            this.writer = new PrintWriter(os);
        }
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = this.arg(outputDir);
    }

    private void log(String msg) {
        if (this.writer != null) {
            this.writer.println(msg);
            this.writer.flush();
        }
    }

    private String arg(String arg) {
        if (arg == null) {
            return arg;
        }
        String s = arg.trim();
        if (s.indexOf(" ") != -1) {
            s = "\"" + s + "\"";
        }
        return s;
    }

    private Method getCompileMethod() {
        if (compileMethod != null) {
            return compileMethod;
        }
        if (jdtCompiler == null) {
            IPluginRegistry registry = Platform.getPluginRegistry();
            IPluginDescriptor jdtCorePlugin = registry.getPluginDescriptor(JDT_CORE_PLUGIN);
            if (jdtCorePlugin == null) {
                return null;
            }
            try {
                jdtCompiler = jdtCorePlugin.getPluginClassLoader().loadClass(JDT_COMPILER_CLASS);
                if (jdtCompiler == null) {
                    throw new Exception("org.eclipse.jdt.internal.compiler.batch.Main not found");
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            Class[] classArray = new Class[3];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.io.PrintWriter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.io.PrintWriter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz3;
            compileMethod = jdtCompiler.getMethod("compile", classArray);
            return compileMethod;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean doCompile() {
        try {
            String args = this.arguments.toString();
            compileMethod = this.getCompileMethod();
            if (compileMethod == null) {
                throw new Exception("org.eclipse.jdt.internal.compiler.batch.Main.compile() not found ");
            }
            compileMethod.invoke((Object)jdtCompiler, args, this.writer, this.writer);
            return true;
        }
        catch (Exception e) {
            this.log("JDT Compiler: " + e.toString());
            return false;
        }
    }
}

