/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.validation;

import com.sapportals.htmlb.util.StringUtils;
import com.sapportals.htmlb.validation.Validator;
import java.util.Locale;

public class LengthValidator
extends Validator {
    private int length;
    private int minlength;

    private LengthValidator() {
    }

    public LengthValidator(int length) {
        this.length = length;
    }

    public LengthValidator(int minlength, int maxlength) {
        this.minlength = minlength;
        this.length = maxlength;
    }

    public String getJavascript(Locale locale) {
        StringBuffer s = new StringBuffer(200);
        if (this.minlength > 0) {
            s.append("checkMinMaxLength(this,");
            s.append(this.minlength);
            s.append(",");
            s.append(this.length);
            s.append(")");
        } else {
            s.append("checkLength(this,");
            s.append(this.length);
            s.append(")");
        }
        return s.toString();
    }

    public String getErrorText(Locale locale) {
        String errText;
        if (this.minlength > 0) {
            if (this.length > 0) {
                errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKLENGTH");
                errText = StringUtils.replace(errText, "&1;", String.valueOf(this.minlength));
                errText = StringUtils.replace(errText, "&2;", String.valueOf(this.length));
            } else {
                errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKMINL");
                errText = StringUtils.replace(errText, "&1;", String.valueOf(this.minlength));
            }
        } else {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKMAXL");
            errText = StringUtils.replace(errText, "&1;", String.valueOf(this.length));
        }
        return errText;
    }
}

