/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.validation;

import com.sapportals.htmlb.type.AbstractRangeType;
import com.sapportals.htmlb.util.StringUtils;
import com.sapportals.htmlb.validation.RangeValidator;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class IntegerValidator
extends RangeValidator {
    public String getJavascript(Locale locale) {
        AbstractRangeType min = this.getMin();
        AbstractRangeType max = this.getMax();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
        StringBuffer s = new StringBuffer(3);
        s.append("P");
        s.append(dfs.getMinusSign());
        s.append(dfs.getGroupingSeparator());
        return this.getJavascriptFuncThisParamMinMax("checkInteger", s.toString(), min == null ? "" : min.toString(), max == null ? "" : max.toString());
    }

    public String getErrorText(Locale locale) {
        String errText;
        AbstractRangeType min = this.getMin();
        AbstractRangeType max = this.getMax();
        if (min == null && max == null) {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKINTEGER");
        } else if (min != null && max != null) {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKINTEGER_RANGE");
            errText = StringUtils.replace(errText, "&1;", min.toString(locale));
            errText = StringUtils.replace(errText, "&2;", max.toString(locale));
        } else if (min != null) {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKINTEGER_LR");
            errText = StringUtils.replace(errText, "&1;", min.toString(locale));
        } else {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKINTEGER_HR");
            errText = StringUtils.replace(errText, "&1;", max.toString(locale));
        }
        return errText;
    }
}

