/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.validation;

import com.sapportals.htmlb.type.AbstractRangeType;
import com.sapportals.htmlb.util.StringUtils;
import com.sapportals.htmlb.validation.RangeValidator;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class FloatValidator
extends RangeValidator {
    private AbstractRangeType minimum;
    private AbstractRangeType maximum;

    public FloatValidator() {
    }

    public FloatValidator(AbstractRangeType minimum, AbstractRangeType maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public String getJavascript(Locale locale) {
        AbstractRangeType max;
        AbstractRangeType min = this.getMin();
        if (min == null) {
            min = this.minimum;
        }
        if ((max = this.getMax()) == null) {
            max = this.maximum;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
        StringBuffer s = new StringBuffer(4);
        s.append("P");
        s.append(dfs.getMinusSign());
        s.append(dfs.getGroupingSeparator());
        s.append(dfs.getDecimalSeparator());
        return this.getJavascriptFuncThisParamMinMax("checkFloat", s.toString(), min == null ? "" : min.toString(), max == null ? "" : max.toString());
    }

    public String getErrorText(Locale locale) {
        String errText;
        AbstractRangeType max;
        AbstractRangeType min = this.getMin();
        if (min == null) {
            min = this.minimum;
        }
        if ((max = this.getMax()) == null) {
            max = this.maximum;
        }
        if (min == null && max == null) {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKBCD");
        } else if (min != null && max != null) {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKBCD_RANGE");
            errText = StringUtils.replace(errText, "&1;", min.toString(locale));
            errText = StringUtils.replace(errText, "&2;", max.toString(locale));
        } else if (min != null) {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKBCD_LR");
            errText = StringUtils.replace(errText, "&1;", min.toString(locale));
        } else {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKBCD_HR");
            errText = StringUtils.replace(errText, "&1;", max.toString(locale));
        }
        return errText;
    }
}

