/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.validation;

import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.type.AbstractRangeType;
import com.sapportals.htmlb.type.TypeFormatter;
import com.sapportals.htmlb.util.StringUtils;
import com.sapportals.htmlb.validation.RangeValidator;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class DateValidator
extends RangeValidator {
    public String getJavascript(Locale locale) {
        SimpleDateFormat sdf = (SimpleDateFormat)TypeFormatter.getFormat(locale, DataType.DATE);
        AbstractRangeType min = this.getMin();
        AbstractRangeType max = this.getMax();
        return this.getJavascriptFuncThisParamMinMax("checkDate", sdf.toPattern(), min == null ? "" : StringUtils.replace(min.toString(), "-", ""), max == null ? "" : StringUtils.replace(max.toString(), "-", ""));
    }

    public String getErrorText(Locale locale) {
        String errText;
        AbstractRangeType min = this.getMin();
        AbstractRangeType max = this.getMax();
        if (min == null && max == null) {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKDATE");
        } else if (min != null && max != null) {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKDATE_RANGE");
            errText = StringUtils.replace(errText, "&1;", min.toString(locale));
            errText = StringUtils.replace(errText, "&2;", max.toString(locale));
        } else if (min != null) {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKDATE_LR");
            errText = StringUtils.replace(errText, "&1;", min.toString(locale));
        } else {
            errText = this.getResourceBundle(locale).getString("TXT_HTMLB_ERR_CHECKDATE_HR");
            errText = StringUtils.replace(errText, "&1;", max.toString(locale));
        }
        return errText;
    }
}

