/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.util;

import com.sapportals.htmlb.util.EmptyEnumeration;
import java.util.Iterator;

public class IndexedLinkedList {
    int count;
    Entry root;
    Entry last;

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(Object value) {
        Entry temp = this.root;
        while (temp != null) {
            if (value.equals(temp.value)) {
                return true;
            }
            temp = temp.next;
        }
        return false;
    }

    public int getFirstIndex() {
        if (this.root != null) {
            return this.root.index;
        }
        return -1;
    }

    public boolean containsIndex(int index) {
        return this.get(index) != null;
    }

    public int getIndexIndex(int index) {
        int indexIndex = 1;
        Entry temp = this.root;
        while (temp != null) {
            if (temp.index == index) {
                return indexIndex;
            }
            temp = temp.next;
            ++indexIndex;
        }
        return -1;
    }

    public Object get(int index) {
        Entry temp = this.root;
        while (temp != null) {
            if (index == temp.index) {
                return temp.value;
            }
            temp = temp.next;
        }
        return null;
    }

    public Object put(int index, Object value) {
        if (this.root == null) {
            this.root = new Entry(index, value);
            ++this.count;
        } else {
            Entry newEntry;
            Entry temp = this.root;
            Entry prev = null;
            while (temp != null) {
                if (temp.index == index) {
                    Object oldValue = temp.value;
                    temp.value = value;
                    return oldValue;
                }
                if (temp.index > index) {
                    Entry newEntry2 = new Entry(index, value);
                    newEntry2.next = temp;
                    if (prev == null) {
                        this.root = newEntry2;
                    } else {
                        prev.next = newEntry2;
                    }
                    ++this.count;
                    return null;
                }
                prev = temp;
                temp = temp.next;
            }
            prev.next = newEntry = new Entry(index, value);
            ++this.count;
        }
        return null;
    }

    public Object remove(int index) {
        Object oldValue = null;
        Entry temp = this.root;
        Entry prev = null;
        while (temp != null && temp.index != index) {
            prev = temp;
            temp = temp.next;
        }
        if (temp != null) {
            oldValue = temp.value;
            temp.value = null;
            prev.next = temp.next;
            --this.count;
        }
        return oldValue;
    }

    public void clear() {
        Entry temp = this.root;
        while (temp != null) {
            Entry help = temp.next;
            temp.next = null;
            temp.value = null;
            temp = help;
        }
        this.count = 0;
    }

    public Iterator values() {
        if (this.root == null) {
            return EmptyEnumeration.getInstance();
        }
        return new ListValueIterator(this.root);
    }

    private static class Entry {
        int index;
        Object value;
        Entry next;

        Entry(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        public int getIndex() {
            return this.index;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public Entry getNext() {
            return this.next;
        }

        public void setNext(Entry next) {
            this.next = next;
        }

        public String toString() {
            return this.index + "=" + this.value;
        }
    }

    private static class ListValueIterator
    implements Iterator {
        Entry current;

        ListValueIterator(Entry start) {
            this.current = start;
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() {
            Entry temp = this.current;
            this.current = this.current.next;
            return temp.value;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

