/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.util;

import com.sapportals.htmlb.enum.Enum;
import com.sapportals.htmlb.util.IHtmlbEncoder;
import java.io.IOException;
import java.lang.reflect.Field;

public class DefaultHtmlbEncoder
implements IHtmlbEncoder {
    private static final String HTMLB_TLA = "@csh@";
    private static final String HTMLB_CLS = "com.sapportals.htmlb";
    private static final String HTMLB_NUL = "@0@";
    private int position = 0;
    private StringBuffer buffer = null;
    private String encodedString = null;

    public void prepareEncoding() throws IOException {
        this.buffer = new StringBuffer(8192);
    }

    public void addProperty(String value) throws IOException {
        if (value != null) {
            if (value.startsWith(HTMLB_CLS)) {
                value = HTMLB_TLA + value.substring(20);
            }
            this.addNext(value);
        } else {
            this.addNext(HTMLB_NUL);
        }
    }

    public void addProperty(Enum value) throws IOException {
        StringBuffer b = null;
        String className = null;
        if (value != null) {
            String stringValue = value.getStringValue();
            String fieldName = null;
            Object o = null;
            Enum e = null;
            className = value.getClass().getName();
            Field[] fields = value.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                try {
                    Class<?> componentClass = Class.forName(className);
                    o = componentClass.getField(fields[i].getName()).get(null);
                    if (o instanceof Enum && (e = (Enum)o).getStringValue().equals(stringValue)) {
                        fieldName = fields[i].getName();
                        i = fields.length;
                    }
                }
                catch (Exception x) {
                    e = null;
                }
                ++i;
            }
            if (fieldName != null) {
                b = new StringBuffer(40);
                b.append(className);
                b.append(':');
                b.append(fieldName);
            }
        }
        if (b != null) {
            this.addProperty(b.toString());
        } else {
            this.addProperty((String)null);
        }
    }

    public void addProperty(int value) throws IOException {
        this.addNext(String.valueOf(value));
    }

    public void addProperty(boolean value) throws IOException {
        StringBuffer b = new StringBuffer(10);
        b.append(value);
        this.addNext(b.toString());
    }

    public String getEncodedString() throws IOException {
        return this.buffer.toString();
    }

    public void prepareDecoding(String encodedString) throws IOException {
        this.encodedString = encodedString;
        this.position = 0;
    }

    public Enum getEnumProperty() throws IOException {
        Enum e = null;
        String value = this.getStringProperty();
        if (value != null) {
            String className = null;
            String enumValue = null;
            int pos = value.indexOf(58);
            className = value.substring(0, pos);
            enumValue = value.substring(pos + 1);
            try {
                Class<?> componentClass = Class.forName(className);
                Object o = componentClass.getField(enumValue).get(null);
                if (o instanceof Enum) {
                    e = (Enum)o;
                }
            }
            catch (Exception x) {
                e = null;
            }
        }
        return e;
    }

    public String getStringProperty() throws IOException {
        String value = this.getNext();
        if (value != null && value.length() > 0 && value.charAt(0) == '@') {
            if (value.equals(HTMLB_NUL)) {
                value = null;
            } else if (value.startsWith(HTMLB_TLA)) {
                value = HTMLB_CLS + value.substring(5);
            }
        }
        return value;
    }

    public int getIntProperty() throws IOException {
        String value = this.getNext();
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    public boolean getBooleanProperty() throws IOException {
        String value = this.getNext();
        if (value != null) {
            Boolean b = new Boolean(value);
            return b;
        }
        return false;
    }

    public void finishDecoding() throws IOException {
    }

    private void addNext(String value) {
        this.buffer.append(DefaultHtmlbEncoder.escape(value));
        this.buffer.append(';');
    }

    private String getNext() {
        String value = null;
        int end = this.encodedString.indexOf(59, this.position);
        if (end > -1) {
            value = this.encodedString.substring(this.position, end);
            value = DefaultHtmlbEncoder.unEscape(value);
            this.position = end + 1;
        }
        return value;
    }

    public static String escape(String str) {
        StringBuffer es = null;
        char c = '\u0000';
        int start = 0;
        int end = 0;
        int len = 0;
        if (str != null) {
            len = str.length();
            if (len > 0) {
                int i = 0;
                while (i < len) {
                    c = str.charAt(i);
                    if (c == ';' || c == '%' || c == '\"' || c == ':') {
                        if (es == null) {
                            es = new StringBuffer(60);
                        }
                        es.append(str.substring(start, i));
                        es.append("%");
                        es.append(Integer.toHexString(c));
                        es.append("%");
                        start = i + 1;
                        end = i + 1;
                    } else {
                        end = i;
                    }
                    ++i;
                }
            }
            if (es != null && es.length() > 0) {
                es.append(str.substring(start, len));
                return es.toString();
            }
            return str;
        }
        return null;
    }

    public static String unEscape(String str) {
        StringBuffer es = null;
        char c = '\u0000';
        String value = null;
        int pos = 0;
        int len = 0;
        int start = 0;
        int end = 0;
        if (str != null) {
            len = str.length();
            if (len > 0) {
                int i = 0;
                while (i < len) {
                    c = str.charAt(i);
                    if (c == '%') {
                        if (es == null) {
                            es = new StringBuffer(60);
                        }
                        es.append(str.substring(start, i));
                        pos = str.indexOf(37, i + 1);
                        value = str.substring(i + 1, pos);
                        c = (char)Integer.parseInt(value, 16);
                        es.append(c);
                        i = pos;
                        start = i + 1;
                        end = i + 1;
                    } else {
                        end = i;
                    }
                    ++i;
                }
            }
            if (es != null && es.length() > 0) {
                es.append(str.substring(start, len));
                return es.toString();
            }
            return str;
        }
        return null;
    }
}

