/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.util;

import com.sapportals.htmlb.util.Log;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Config {
    private static Properties props = null;

    public Config() {
        this.init();
    }

    public String getProperty(String key) {
        String value = null;
        if (props != null) {
            value = props.getProperty(key);
        }
        return value;
    }

    private void init() {
        block10: {
            if (props == null) {
                props = new Properties();
                String propertyPath = System.getProperty("htmlb.property.name");
                if (propertyPath != null) {
                    try {
                        FileInputStream input = new FileInputStream(propertyPath);
                        if (input == null) break block10;
                        try {
                            props.load(input);
                        }
                        catch (IOException e) {
                            Log.getLogLocation(false).debugT("Config", "init " + e.getMessage());
                        }
                    }
                    catch (FileNotFoundException fnf) {
                        Log.getLogLocation(false).debugT("Config", "init " + fnf.getMessage());
                    }
                } else {
                    InputStream input;
                    ClassLoader loader = this.getClass().getClassLoader();
                    if (loader != null && (input = loader.getResourceAsStream("htmlb.properties")) != null) {
                        try {
                            props.load(input);
                        }
                        catch (IOException e) {
                            Log.getLogLocation(false).debugT("Config", "init " + e.getMessage());
                        }
                    }
                }
            }
        }
    }
}

