/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.util;

import com.sapportals.htmlb.util.CleanStringOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CleanStringInputStream
extends InputStream {
    byte[] buffer;
    int bufferLen;
    transient int currentPos;
    transient boolean ended;
    transient int eof;
    static byte[] charset = new byte[255];
    static String charset_old;

    public CleanStringInputStream(String source) {
        int len = source.length();
        this.bufferLen = len / 4 * 3;
        this.buffer = new byte[this.bufferLen + 3];
        int modulo = len % 4;
        if (modulo == 2) {
            ++this.bufferLen;
        } else if (modulo == 3) {
            this.bufferLen += 2;
        }
        int i = 0;
        while (i < len && !this.ended) {
            this.readBuffer(source, i, len);
            i += 4;
        }
        this.currentPos = 0;
        this.ended = false;
        this.eof = 0;
    }

    private void readBuffer(String string, int pos, int length) {
        int value = 0;
        int remains = length - pos;
        if (remains >= 4) {
            remains = 0;
        }
        char cAtPos = string.charAt(pos);
        if (this.eof == 0 && cAtPos != '*') {
            int endpos;
            String test = null;
            int testend = pos + 4;
            if (testend > length) {
                testend = length;
            }
            if ((endpos = (test = string.substring(pos, testend)).indexOf(42)) > -1) {
                remains = endpos;
                this.eof = testend - pos - endpos;
            }
        }
        if (cAtPos == '*') {
            this.ended = true;
        }
        if (!this.ended) {
            switch (remains) {
                case 0: {
                    char c = string.charAt(pos++);
                    value += charset[c];
                    value <<= 6;
                    c = string.charAt(pos++);
                    value += charset[c];
                    value <<= 6;
                    c = string.charAt(pos++);
                    value += charset[c];
                    value <<= 6;
                    c = string.charAt(pos);
                    this.buffer[this.currentPos++] = (byte)((value += charset[c]) >> 16);
                    this.buffer[this.currentPos++] = (byte)(value >> 8);
                    this.buffer[this.currentPos++] = (byte)value;
                    break;
                }
                case 2: {
                    char c = string.charAt(pos++);
                    value += charset[c];
                    value <<= 2;
                    c = string.charAt(pos++);
                    this.buffer[this.currentPos++] = (byte)(value += charset[c]);
                    break;
                }
                case 3: {
                    char c = string.charAt(pos++);
                    value += charset[c];
                    value <<= 6;
                    c = string.charAt(pos++);
                    value += charset[c];
                    value <<= 4;
                    c = string.charAt(pos++);
                    this.buffer[this.currentPos++] = (byte)((value += charset[c]) >> 8);
                    this.buffer[this.currentPos++] = (byte)value;
                }
            }
        } else {
            int endLength = CleanStringOutputStream.end.length() - this.eof;
            int i = 0;
            while (i < endLength) {
                if (length - 1 < pos + i) {
                    System.out.println("Warning: string was trucated by " + (endLength - i) + " Bytes. luckyly we had more.");
                    i = endLength;
                } else if (string.charAt(pos + i) != '*') {
                    System.out.println("Warning: string was trucated by " + (endLength - i) + " Bytes. luckyly we had more.");
                    i = endLength;
                }
                ++i;
            }
            if (length > pos + endLength) {
                String extraBytes = string.substring(pos + endLength, length);
                System.out.println("Warning: extra characters detected and ignored [" + extraBytes + "]");
                Integer j = null;
                int i2 = 0;
                while (i2 < extraBytes.length()) {
                    j = new Integer(extraBytes.charAt(i2));
                    System.out.println("Char value: " + j);
                    ++i2;
                }
            }
        }
    }

    public int read() throws IOException {
        if (this.currentPos <= this.bufferLen) {
            int result = this.buffer[this.currentPos++];
            return result &= 0xFF;
        }
        return -1;
    }

    static {
        int i = 0;
        while (i < 255) {
            CleanStringInputStream.charset[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < CleanStringOutputStream.charset.length) {
            CleanStringInputStream.charset[CleanStringOutputStream.charset[i2]] = (byte)i2;
            ++i2;
        }
        charset_old = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_";
    }
}

