/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.nn6;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.defaultJavaScriptRenderer;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.TagRenderer;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controls.Label;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.LabelDesign;
import com.sapportals.htmlb.unifiedrendering.enum.LabelSize;
import com.sapportals.htmlb.unifiedrendering.enum.Visibility;
import java.io.PrintWriter;
import java.util.List;

public class LabelRenderer
extends defaultJavaScriptRenderer {
    private static List textKeys = UrUtil.getUrTextKeys("LABEL");

    public void render(Component component, IPageContext manager) {
        Label pControl = new Label(component, manager);
        int x = 0;
        while (x < textKeys.size()) {
            manager.getDocument().registerStandardText((String)textKeys.get(x));
            ++x;
        }
        manager.registerStylesheet("ur_fc");
        this.renderLabelFragment(pControl, manager, pControl.getId(), pControl.getTooltip(), pControl.getLabelFor(), pControl.getWrapping(), pControl.getText(), pControl.getInvalid(), pControl.getRequired(), pControl.getEnabled(), pControl.getReadonly(), pControl.getEncode(), pControl.getSize(), pControl.getDesignBar(), pControl.getWidth(), pControl.getHasIcon(), pControl.getIconSrc(), pControl.getRequiredIndicatorTooltip(), pControl.getTextDirection(), pControl.getVisibility(), pControl.getLabeledControlName());
    }

    public void renderLabelFragment(IUIElement pControl, IPageContext manager, String pId, String pTooltip, String pLabelFor, boolean pWrapping, String pText, boolean pInvalid, boolean pRequired, boolean pEnabled, boolean pReadonly, boolean pEncode, LabelSize pSize, LabelDesign pDesignBar, String pWidth, boolean pHasIcon, String pIconSrc, String pRequiredIndicatorTooltip, ForcedTextDirection pTextDirection, Visibility pVisibility, String pLabeledControlName) {
        String eventHandler;
        CharSequence attribute;
        PrintWriter out = (PrintWriter)manager.getWriter();
        StringBuffer _style_collector = new StringBuffer();
        boolean encode = false;
        TagRenderer.writeBeginTag(out, "label");
        _style_collector = new StringBuffer();
        if (pVisibility == Visibility.BLANK) {
            attribute = "hidden";
            _style_collector.append("visibility:").append((String)attribute).append(";");
        }
        if ((eventHandler = pControl.getJSEventFunction(ClientEvent.LABELFOCUS, manager)) != null && eventHandler.length() > 0) {
            manager.write(" onclick=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if (!pEnabled) {
            attribute = "";
            TagRenderer.writeAttribute(out, "disabled", (String)attribute, encode);
        }
        attribute = String.valueOf(0);
        TagRenderer.writeAttribute(out, "tabindex", (String)attribute, encode);
        attribute = pId;
        if (!"".equals(attribute)) {
            TagRenderer.writeAttribute(out, "id", (String)attribute, encode);
        }
        attribute = pLabelFor;
        TagRenderer.writeAttribute(out, "for", (String)attribute, encode);
        attribute = new StringBuffer();
        ((StringBuffer)attribute).append("urLbl");
        if (!pEnabled) {
            if (pSize == LabelSize.SMALL) {
                ((StringBuffer)attribute).append("DsblSml");
            } else {
                ((StringBuffer)attribute).append("Dsbl1");
            }
        } else if (pSize == LabelSize.SMALL) {
            ((StringBuffer)attribute).append("Sml");
        } else {
            ((StringBuffer)attribute).append("Std1");
        }
        if (pInvalid) {
            ((StringBuffer)attribute).append("Inv");
        }
        if (pDesignBar == LabelDesign.LIGHT) {
            ((StringBuffer)attribute).append("Bar");
        }
        ((StringBuffer)attribute).append(" urVt");
        TagRenderer.writeAttribute(out, "class", (StringBuffer)attribute, encode);
        attribute = pTooltip;
        if (!"".equals(attribute)) {
            TagRenderer.writeAttribute(out, "title", (String)attribute, encode);
        }
        if (!pWrapping) {
            attribute = "nowrap";
            _style_collector.append("white-space:").append((String)attribute).append(";");
        }
        if (_style_collector.length() != 0) {
            TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
        }
        TagRenderer.writeTagRightChar(out);
        this.renderLabelContentFragment(pControl, manager, pText, pRequired, pRequiredIndicatorTooltip, pTextDirection);
        TagRenderer.writeEndTag(out, "label");
    }

    public void renderLabelContentFragment(IUIElement pControl, IPageContext manager, String pText, boolean pRequired, String pRequiredIndicatorTooltip, ForcedTextDirection pTextDirection) {
        PrintWriter out = (PrintWriter)manager.getWriter();
        boolean encode = false;
        TagRenderer.writeBeginTag(out, "span");
        TagRenderer.writeAttribute(out, "class", "urLblPadding", encode);
        TagRenderer.writeTagRightChar(out);
        out.write(String.valueOf(pText));
        TagRenderer.writeEndTag(out, "span");
        if (pRequired) {
            TagRenderer.writeBeginTag(out, "span");
            TagRenderer.writeAttribute(out, "class", "urLblReq", encode);
            String attribute = pRequiredIndicatorTooltip;
            if (!"".equals(attribute)) {
                TagRenderer.writeAttribute(out, "title", attribute, encode);
            }
            TagRenderer.writeTagRightChar(out);
            TagRenderer.writeSpace(out);
            out.write(String.valueOf("*"));
            TagRenderer.writeEndTag(out, "span");
        }
    }
}

