/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.nn6;

import com.sapportals.htmlb.Button;
import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.event.ButtonClickEvent;
import com.sapportals.htmlb.rendering.ComponentValidationRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.defaultJavaScriptRenderer;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.TagRenderer;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ICaption;
import com.sapportals.htmlb.unifiedrendering.enum.ButtonDesign;
import com.sapportals.htmlb.unifiedrendering.enum.ButtonSize;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.Visibility;
import com.sapportals.htmlb.unifiedrendering.ie5.UrBaseRenderer;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ButtonRenderer
extends defaultJavaScriptRenderer {
    private static List textKeys = UrUtil.getUrTextKeys("BUTTON");

    public void render(Component component, IPageContext manager) {
        com.sapportals.htmlb.unifiedrendering.controls.Button pControl = new com.sapportals.htmlb.unifiedrendering.controls.Button(component, manager);
        Button button = (Button)component;
        if (button.getOnClick() != null || button.getOnClientClick() != null) {
            manager.write(ButtonClickEvent.renderJSFunction(manager, button));
        }
        HashSet<EventTrigger> validationTriggers = new HashSet<EventTrigger>();
        validationTriggers.add(EventTrigger.ON_CLICK);
        ComponentValidationRenderer.renderEventValidationFunction(validationTriggers, (Button)component, manager);
        if (button.isJsObjectNeeded()) {
            String generatedId = manager.getParamIdForComponent(button);
            Form form = manager.getCurrentForm();
            if (!button.isEnabled()) {
                button.setEnabled(true);
                form.addForcedEnabledElement(generatedId, button);
            }
            form.addForceJavascriptInterface(button, generatedId);
        }
        int x = 0;
        while (x < textKeys.size()) {
            manager.getDocument().registerStandardText((String)textKeys.get(x));
            ++x;
        }
        manager.registerStylesheet("ur_fc");
        this.renderButtonFragment(pControl, manager, pControl.getDesign(), pControl.getSize(), pControl.getId(), pControl.getWidth(), pControl.getTooltip(), pControl.getText(), pControl.getEnabled(), pControl.getHasButtonCaption(), pControl.getButtonCaption(), pControl.getTextDirection(), pControl.getVisibility());
    }

    public void renderButtonFragment(IUIElement pControl, IPageContext manager, ButtonDesign pDesign, ButtonSize pSize, String pId, String pWidth, String pTooltip, String pText, boolean pEnabled, boolean pHasButtonCaption, ICaption pButtonCaption, ForcedTextDirection pTextDirection, Visibility pVisibility) {
        PrintWriter out = (PrintWriter)manager.getWriter();
        StringBuffer _style_collector = new StringBuffer();
        boolean encode = false;
        if (!pEnabled) {
            CharSequence attribute;
            TagRenderer.writeBeginTag(out, "span");
            _style_collector = new StringBuffer();
            if (pVisibility == Visibility.BLANK) {
                attribute = "hidden";
                _style_collector.append("visibility:").append((String)attribute).append(";");
                attribute = "nowrap";
                _style_collector.append("white-space:").append((String)attribute).append(";");
            } else {
                attribute = "nowrap";
                _style_collector.append("white-space:").append((String)attribute).append(";");
            }
            if (manager.getIs508()) {
                attribute = String.valueOf(0);
                TagRenderer.writeAttribute(out, "tabindex", (String)attribute, encode);
                attribute = String.valueOf(0);
                TagRenderer.writeAttribute(out, "ti", (String)attribute, encode);
            }
            attribute = new StringBuffer();
            if (pDesign == ButtonDesign.EMPHASIZED) {
                if (pSize == ButtonSize.SMALL) {
                    ((StringBuffer)attribute).append("urBtnSmlEmph");
                } else {
                    ((StringBuffer)attribute).append("urBtnEmph1");
                }
            } else if (pSize == ButtonSize.SMALL) {
                ((StringBuffer)attribute).append("urBtnSml");
            } else {
                ((StringBuffer)attribute).append("urBtnStd1");
            }
            if (pDesign == ButtonDesign.PREVIOUS) {
                ((StringBuffer)attribute).append("PrevStep");
            } else if (pDesign == ButtonDesign.NEXT) {
                ((StringBuffer)attribute).append("NextStep");
            }
            ((StringBuffer)attribute).append("Dsbl");
            ((StringBuffer)attribute).append(" urV");
            TagRenderer.writeAttribute(out, "class", (StringBuffer)attribute, encode);
            attribute = pId;
            if (!"".equals(attribute)) {
                TagRenderer.writeAttribute(out, "id", (String)attribute, encode);
            }
            attribute = "Button";
            TagRenderer.writeAttribute(out, "ct", (String)attribute, encode);
            if (manager.getIs508()) {
                attribute = new StringBuffer();
                ArrayList<String> paramList = new ArrayList<String>();
                paramList.add("#SAPUR_BUTTON");
                paramList.add(pText);
                paramList.add("#SAPUR_DISABLED");
                paramList.add(pTooltip);
                ((StringBuffer)attribute).append(TagRenderer.translate("#SAPUR_BUTTON_WHL", paramList, manager));
                TagRenderer.writeAttribute(out, "title", (StringBuffer)attribute, encode);
            } else {
                attribute = pTooltip;
                if (!"".equals(attribute)) {
                    TagRenderer.writeAttribute(out, "title", (String)attribute, encode);
                }
            }
            attribute = pWidth;
            if (!"".equals(attribute)) {
                _style_collector.append("width:").append((String)attribute).append(";");
            }
            if (_style_collector.length() != 0) {
                TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
            }
            TagRenderer.writeTagRightChar(out);
            TagRenderer.writeBeginTag(out, "span");
            attribute = new StringBuffer();
            if (pDesign == ButtonDesign.EMPHASIZED) {
                ((StringBuffer)attribute).append("urBtnPaddingEmph");
            } else if (pDesign == ButtonDesign.STANDARD) {
                ((StringBuffer)attribute).append("urBtnPadding");
            } else if (pDesign == ButtonDesign.PREVIOUS) {
                ((StringBuffer)attribute).append("urBtnPrevPadding");
            } else if (pDesign == ButtonDesign.NEXT) {
                ((StringBuffer)attribute).append("urBtnNextPadding");
            }
            TagRenderer.writeAttribute(out, "class", (StringBuffer)attribute, encode);
            TagRenderer.writeTagRightChar(out);
            if (!pHasButtonCaption) {
                UrBaseRenderer pUrBaseRenderer = new UrBaseRenderer();
                pUrBaseRenderer.renderUrBaseTextDirTagFragment(pControl, manager, pTextDirection, pText);
            }
            TagRenderer.writeEndTag(out, "span");
            TagRenderer.writeEndTag(out, "span");
        } else {
            CharSequence attribute;
            TagRenderer.writeBeginTag(out, "a");
            TagRenderer.writeAttribute(out, "href", "javascript:void(0);", encode);
            _style_collector = new StringBuffer();
            if (pVisibility == Visibility.BLANK) {
                attribute = "hidden";
                _style_collector.append("visibility:").append((String)attribute).append(";");
                attribute = "nowrap";
                _style_collector.append("white-space:").append((String)attribute).append(";");
            } else {
                attribute = "nowrap";
                _style_collector.append("white-space:").append((String)attribute).append(";");
            }
            String eventHandler = pControl.getJSEventFunction(ClientEvent.BUTTONCLICK, manager);
            if (eventHandler != null && eventHandler.length() > 0) {
                manager.write(" onclick=\"");
                manager.write(eventHandler);
                manager.write("\" ");
            }
            if ((eventHandler = pControl.getJSEventFunction(ClientEvent.BUTTONCLICK, manager)) != null && eventHandler.length() > 0) {
                manager.write(" onkeypress=\"");
                manager.write(eventHandler);
                manager.write("\" ");
            }
            attribute = new StringBuffer();
            if (pDesign == ButtonDesign.EMPHASIZED) {
                if (pSize == ButtonSize.SMALL) {
                    ((StringBuffer)attribute).append("urBtnSmlEmph");
                } else {
                    ((StringBuffer)attribute).append("urBtnEmph1");
                }
            } else if (pSize == ButtonSize.SMALL) {
                ((StringBuffer)attribute).append("urBtnSml");
            } else {
                ((StringBuffer)attribute).append("urBtnStd1");
            }
            if (pDesign == ButtonDesign.PREVIOUS) {
                ((StringBuffer)attribute).append("PrevStep");
            } else if (pDesign == ButtonDesign.NEXT) {
                ((StringBuffer)attribute).append("NextStep");
            }
            ((StringBuffer)attribute).append(" urV");
            TagRenderer.writeAttribute(out, "class", (StringBuffer)attribute, encode);
            attribute = pId;
            if (!"".equals(attribute)) {
                TagRenderer.writeAttribute(out, "id", (String)attribute, encode);
            }
            attribute = "Button";
            TagRenderer.writeAttribute(out, "ct", (String)attribute, encode);
            if (manager.getIs508()) {
                attribute = new StringBuffer();
                ArrayList<String> paramList = new ArrayList<String>();
                paramList.add("#SAPUR_BUTTON");
                paramList.add(pText);
                paramList.add("#SAPUR_BUTTON_ENABLED");
                paramList.add(pTooltip);
                ((StringBuffer)attribute).append(TagRenderer.translate("#SAPUR_BUTTON_WHL", paramList, manager));
                TagRenderer.writeAttribute(out, "title", (StringBuffer)attribute, encode);
            } else {
                attribute = pTooltip;
                if (!"".equals(attribute)) {
                    TagRenderer.writeAttribute(out, "title", (String)attribute, encode);
                }
            }
            attribute = pWidth;
            if (!"".equals(attribute)) {
                _style_collector.append("width:").append((String)attribute).append(";");
            }
            if (_style_collector.length() != 0) {
                TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
            }
            TagRenderer.writeTagRightChar(out);
            TagRenderer.writeBeginTag(out, "span");
            attribute = new StringBuffer();
            if (pDesign == ButtonDesign.EMPHASIZED) {
                ((StringBuffer)attribute).append("urBtnPaddingEmph");
            } else if (pDesign == ButtonDesign.STANDARD) {
                ((StringBuffer)attribute).append("urBtnPadding");
            } else if (pDesign == ButtonDesign.PREVIOUS) {
                ((StringBuffer)attribute).append("urBtnPrevPadding");
            } else if (pDesign == ButtonDesign.NEXT) {
                ((StringBuffer)attribute).append("urBtnNextPadding");
            }
            TagRenderer.writeAttribute(out, "class", (StringBuffer)attribute, encode);
            TagRenderer.writeTagRightChar(out);
            if (!pHasButtonCaption) {
                UrBaseRenderer pUrBaseRenderer = new UrBaseRenderer();
                pUrBaseRenderer.renderUrBaseTextDirTagFragment(pControl, manager, pTextDirection, pText);
            }
            TagRenderer.writeEndTag(out, "span");
            TagRenderer.writeEndTag(out, "a");
        }
    }
}

