/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.ie5;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.TextView;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.TagRenderer;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.HorizontalAlign;
import com.sapportals.htmlb.unifiedrendering.enum.TextViewDesign;
import com.sapportals.htmlb.unifiedrendering.enum.TextViewLayout;
import com.sapportals.htmlb.unifiedrendering.enum.TextViewSemanticColor;
import com.sapportals.htmlb.unifiedrendering.enum.Visibility;
import java.io.PrintWriter;
import java.util.List;

public class TextViewRenderer
extends AtomHtmlbRenderer {
    private static List textKeys = UrUtil.getUrTextKeys("TEXTVIEW");

    public void render(Component component, IPageContext manager) {
        com.sapportals.htmlb.unifiedrendering.controls.TextView pControl = new com.sapportals.htmlb.unifiedrendering.controls.TextView(component, manager);
        if (pControl.getHasPopupMenu()) {
            HoverMenu menu = ((TextView)component).getHoverMenu();
            if (menu.requiresForm()) {
                manager.getCurrentForm().registerHoverMenu(menu);
            } else {
                manager.getDocument().registerHoverMenu(menu);
            }
        }
        int x = 0;
        while (x < textKeys.size()) {
            manager.getDocument().registerStandardText((String)textKeys.get(x));
            ++x;
        }
        manager.registerStylesheet("ur_fc");
        this.renderTextViewFragment(pControl, manager, pControl.getId(), pControl.getText(), pControl.getTooltip(), pControl.getWrapping(), pControl.getRequired(), pControl.getDesign(), pControl.getSemanticColor(), pControl.getLayout(), pControl.getHasPopupMenu(), pControl.getIsNested(), pControl.getWidth(), pControl.getAlign(), pControl.getTextDirection(), pControl.getVisibility(), pControl.getTextForTooltip());
    }

    public void renderTextViewFragment(IUIElement pControl, IPageContext manager, String pId, String pText, String pTooltip, boolean pWrapping, boolean pRequired, TextViewDesign pDesign, TextViewSemanticColor pSemanticColor, TextViewLayout pLayout, boolean pHasPopupMenu, boolean pIsNested, String pWidth, HorizontalAlign pAlign, ForcedTextDirection pTextDirection, Visibility pVisibility, String pTextForTooltip) {
        PrintWriter out = (PrintWriter)manager.getWriter();
        boolean encode = false;
        if (pIsNested) {
            TagRenderer.writeBeginTag(out, "span");
            TagRenderer.writeAttribute(out, "class", "urFontStd", encode);
            TagRenderer.writeTagRightChar(out);
            if (pLayout == TextViewLayout.PARAGRAPH) {
                this.renderTextViewContentFragment(pControl, manager, pId, "p", pText, pTooltip, pWrapping, pRequired, pDesign, pSemanticColor, pHasPopupMenu, pIsNested, pWidth, true, pAlign, true, pTextDirection, pVisibility, pTextForTooltip, pLayout);
            } else if (pLayout == TextViewLayout.BLOCK) {
                this.renderTextViewContentFragment(pControl, manager, pId, "div", pText, pTooltip, pWrapping, pRequired, pDesign, pSemanticColor, pHasPopupMenu, pIsNested, pWidth, true, pAlign, true, pTextDirection, pVisibility, pTextForTooltip, pLayout);
            } else {
                this.renderTextViewContentFragment(pControl, manager, pId, "span", pText, pTooltip, pWrapping, pRequired, pDesign, pSemanticColor, pHasPopupMenu, pIsNested, pWidth, false, pAlign, false, pTextDirection, pVisibility, pTextForTooltip, pLayout);
            }
            TagRenderer.writeEndTag(out, "span");
        } else if (pLayout == TextViewLayout.PARAGRAPH) {
            this.renderTextViewContentFragment(pControl, manager, pId, "p", pText, pTooltip, pWrapping, pRequired, pDesign, pSemanticColor, pHasPopupMenu, pIsNested, pWidth, true, pAlign, true, pTextDirection, pVisibility, pTextForTooltip, pLayout);
        } else if (pLayout == TextViewLayout.BLOCK) {
            this.renderTextViewContentFragment(pControl, manager, pId, "div", pText, pTooltip, pWrapping, pRequired, pDesign, pSemanticColor, pHasPopupMenu, pIsNested, pWidth, true, pAlign, true, pTextDirection, pVisibility, pTextForTooltip, pLayout);
        } else {
            this.renderTextViewContentFragment(pControl, manager, pId, "span", pText, pTooltip, pWrapping, pRequired, pDesign, pSemanticColor, pHasPopupMenu, pIsNested, pWidth, false, pAlign, false, pTextDirection, pVisibility, pTextForTooltip, pLayout);
        }
    }

    public void renderTextViewContentFragment(IUIElement pControl, IPageContext manager, String pId, String pTag, String pText, String pTooltip, boolean pWrapping, boolean pRequired, TextViewDesign pDesign, TextViewSemanticColor pSemanticColor, boolean pHasPopupMenu, boolean pIsNested, String pWidth, boolean pHasWidth, HorizontalAlign pAlign, boolean pHasAlign, ForcedTextDirection pTextDirection, Visibility pVisibility, String pTextForTooltip, TextViewLayout pLayout) {
        String eventHandler;
        CharSequence attribute;
        PrintWriter out = (PrintWriter)manager.getWriter();
        StringBuffer _style_collector = new StringBuffer();
        boolean encode = false;
        TagRenderer.writeBeginTag(out, pTag);
        _style_collector = new StringBuffer();
        if (pVisibility == Visibility.BLANK) {
            attribute = "hidden";
            _style_collector.append("visibility:").append((String)attribute).append(";");
        }
        if (manager.getIs508() && !pText.equals("") && !pIsNested) {
            attribute = String.valueOf(0);
            TagRenderer.writeAttribute(out, "tabindex", (String)attribute, encode);
            attribute = String.valueOf(0);
            TagRenderer.writeAttribute(out, "ti", (String)attribute, encode);
            eventHandler = pControl.getJSEventFunction(ClientEvent.TEXTVIEWFOCUS, manager);
            if (eventHandler != null && eventHandler.length() > 0) {
                manager.write(" onfocus=\"");
                manager.write(eventHandler);
                manager.write("\" ");
            }
        }
        if (pHasWidth && !"".equals(attribute = pWidth)) {
            _style_collector.append("width:").append((String)attribute).append(";");
        }
        if (!"".equals(attribute = pId)) {
            TagRenderer.writeAttribute(out, "id", (String)attribute, encode);
        }
        attribute = "TextView";
        TagRenderer.writeAttribute(out, "ct", (String)attribute, encode);
        if (pText.equals("")) {
            attribute = "0px";
            _style_collector.append("margin:").append((String)attribute).append(";");
        } else {
            if (pHasAlign) {
                if (pAlign == HorizontalAlign.ENDOFLINE) {
                    if (manager.getIsRTL()) {
                        attribute = "left";
                        _style_collector.append("text-align:").append((String)attribute).append(";");
                    } else {
                        attribute = "right";
                        _style_collector.append("text-align:").append((String)attribute).append(";");
                    }
                } else if (pAlign == HorizontalAlign.RIGHT) {
                    if (manager.getIsRTL()) {
                        if (pTextDirection == ForcedTextDirection.LTR) {
                            attribute = "right";
                            _style_collector.append("text-align:").append((String)attribute).append(";");
                        }
                    } else {
                        attribute = "right";
                        _style_collector.append("text-align:").append((String)attribute).append(";");
                    }
                } else if (pAlign == HorizontalAlign.CENTER) {
                    attribute = "center";
                    _style_collector.append("text-align:").append((String)attribute).append(";");
                } else if (pAlign == HorizontalAlign.FORCEDLEFT) {
                    if (manager.getIsRTL()) {
                        attribute = "left";
                        _style_collector.append("text-align:").append((String)attribute).append(";");
                    } else if (pTextDirection == ForcedTextDirection.RTL) {
                        attribute = "left";
                        _style_collector.append("text-align:").append((String)attribute).append(";");
                    }
                } else if (pTextDirection == ForcedTextDirection.LTR) {
                    attribute = "right";
                    _style_collector.append("text-align:").append((String)attribute).append(";");
                } else if (pTextDirection == ForcedTextDirection.RTL) {
                    attribute = "left";
                    _style_collector.append("text-align:").append((String)attribute).append(";");
                }
            }
            if ((eventHandler = pControl.getJSEventFunction(ClientEvent.TEXTVIEWDBLCLICK, manager)) != null && eventHandler.length() > 0) {
                manager.write(" ondblclick=\"");
                manager.write(eventHandler);
                manager.write("\" ");
            }
            if (pHasPopupMenu) {
                if (manager.getIs508() && !pText.equals("") && !pIsNested) {
                    attribute = String.valueOf(true);
                    TagRenderer.writeAttribute(out, "mnu", (String)attribute, encode);
                }
                if ((eventHandler = pControl.getJSEventFunction(ClientEvent.TEXTVIEWMOUSEOVER, manager)) != null && eventHandler.length() > 0) {
                    manager.write(" onmouseover=\"");
                    manager.write(eventHandler);
                    manager.write("\" ");
                }
                if ((eventHandler = pControl.getJSEventFunction(ClientEvent.TEXTVIEWCLICK, manager)) != null && eventHandler.length() > 0) {
                    manager.write(" onclick=\"");
                    manager.write(eventHandler);
                    manager.write("\" ");
                }
                if ((eventHandler = pControl.getJSEventFunction(ClientEvent.TEXTVIEWRIGHTCLICK, manager)) != null && eventHandler.length() > 0) {
                    manager.write(" oncontextmenu=\"");
                    manager.write(eventHandler);
                    manager.write("\" ");
                }
                if ((eventHandler = pControl.getJSEventFunction(ClientEvent.TEXTVIEWKEYDOWN, manager)) != null && eventHandler.length() > 0) {
                    manager.write(" onkeydown=\"");
                    manager.write(eventHandler);
                    manager.write("\" ");
                }
            }
            if (!pTextForTooltip.equals("") && manager.getIs508() && !"".equals(attribute = pTextForTooltip)) {
                TagRenderer.writeAttribute(out, "val", (String)attribute, encode);
            }
            if (!"".equals(attribute = pTooltip)) {
                TagRenderer.writeAttribute(out, "title", (String)attribute, encode);
            }
            if (manager.getIs508() && !"".equals(attribute = pTooltip)) {
                TagRenderer.writeAttribute(out, "tt", (String)attribute, encode);
            }
            if (!pWrapping) {
                attribute = "nowrap";
                _style_collector.append("white-space:").append((String)attribute).append(";");
            }
            attribute = new StringBuffer();
            ((StringBuffer)attribute).append("urTxt");
            if (pDesign == TextViewDesign.STANDARD) {
                ((StringBuffer)attribute).append("Std");
            } else if (pDesign == TextViewDesign.EMPHASIZED) {
                ((StringBuffer)attribute).append("Emph");
            } else if (pDesign == TextViewDesign.HEADER1) {
                ((StringBuffer)attribute).append("H1");
            } else if (pDesign == TextViewDesign.HEADER2) {
                ((StringBuffer)attribute).append("H2");
            } else if (pDesign == TextViewDesign.HEADER3) {
                ((StringBuffer)attribute).append("H3");
            } else if (pDesign == TextViewDesign.HEADER4) {
                ((StringBuffer)attribute).append("H4");
            } else if (pDesign == TextViewDesign.LEGEND) {
                ((StringBuffer)attribute).append("Leg");
            } else if (pDesign == TextViewDesign.REFERENCE) {
                ((StringBuffer)attribute).append("Ref");
            } else if (pDesign == TextViewDesign.LABEL) {
                ((StringBuffer)attribute).append("Lbl");
            } else if (pDesign == TextViewDesign.LABEL_SMALL) {
                ((StringBuffer)attribute).append("LblSml");
            } else if (pDesign == TextViewDesign.MONOSPACE) {
                ((StringBuffer)attribute).append("Mono");
            } else {
                ((StringBuffer)attribute).append("Std");
            }
            if (pSemanticColor == TextViewSemanticColor.DIMINISHED) {
                ((StringBuffer)attribute).append(" urTxtDim");
            } else if (pSemanticColor == TextViewSemanticColor.POSITIVE) {
                ((StringBuffer)attribute).append(" urTxtPos");
            } else if (pSemanticColor == TextViewSemanticColor.CRITICAL) {
                ((StringBuffer)attribute).append(" urTxtCrit");
            } else if (pSemanticColor == TextViewSemanticColor.NEGATIVE) {
                ((StringBuffer)attribute).append(" urTxtNeg");
            } else if (pSemanticColor == TextViewSemanticColor.MARKED1) {
                ((StringBuffer)attribute).append(" urTxtM1");
            } else if (pSemanticColor == TextViewSemanticColor.MARKED2) {
                ((StringBuffer)attribute).append(" urTxtM2");
            }
            if ((pDesign == TextViewDesign.STANDARD || pDesign == TextViewDesign.EMPHASIZED || pDesign == TextViewDesign.REFERENCE || pDesign == TextViewDesign.MONOSPACE) && pLayout == TextViewLayout.NATIVE && manager.getHasAdvancedAlignment()) {
                ((StringBuffer)attribute).append(" urVt1");
            }
            TagRenderer.writeAttribute(out, "class", (StringBuffer)attribute, encode);
            if (pTextDirection == ForcedTextDirection.LTR) {
                if (manager.getIsRTL()) {
                    attribute = "ltr";
                    TagRenderer.writeAttribute(out, "dir", (String)attribute, encode);
                }
            } else if (pTextDirection == ForcedTextDirection.RTL && !manager.getIsRTL()) {
                attribute = "rtl";
                TagRenderer.writeAttribute(out, "dir", (String)attribute, encode);
            }
        }
        if (_style_collector.length() != 0) {
            TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
        }
        TagRenderer.writeTagRightChar(out);
        if (!pText.equals("")) {
            out.write(String.valueOf(pText));
            if (pRequired) {
                TagRenderer.writeBeginTag(out, "span");
                TagRenderer.writeAttribute(out, "class", "urTxtReq", encode);
                TagRenderer.writeTagRightChar(out);
                TagRenderer.writeSpace(out);
                out.write(String.valueOf("*"));
                TagRenderer.writeEndTag(out, "span");
            }
            if (pDesign == TextViewDesign.LABEL || pDesign == TextViewDesign.LABEL_SMALL) {
                TagRenderer.writeBeginTag(out, "span");
                TagRenderer.writeAttribute(out, "class", "urTxtLbl", encode);
                TagRenderer.writeTagRightChar(out);
                TagRenderer.writeSpace(out);
                TagRenderer.writeEndTag(out, "span");
            }
        } else {
            if (pRequired) {
                TagRenderer.writeBeginTag(out, "span");
                TagRenderer.writeAttribute(out, "class", "urTxtStd", encode);
                TagRenderer.writeTagRightChar(out);
                TagRenderer.writeBeginTag(out, "span");
                TagRenderer.writeAttribute(out, "class", "urTxtReq", encode);
                TagRenderer.writeTagRightChar(out);
                TagRenderer.writeSpace(out);
                out.write(String.valueOf("*"));
                TagRenderer.writeEndTag(out, "span");
                TagRenderer.writeEndTag(out, "span");
            }
            if (pDesign == TextViewDesign.LABEL || pDesign == TextViewDesign.LABEL_SMALL) {
                TagRenderer.writeBeginTag(out, "span");
                TagRenderer.writeAttribute(out, "class", "urTxtLbl", encode);
                TagRenderer.writeTagRightChar(out);
                TagRenderer.writeSpace(out);
                TagRenderer.writeEndTag(out, "span");
            }
        }
        TagRenderer.writeEndTag(out, pTag);
    }
}

