/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.ie5;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.IURCollection;
import com.sapportals.htmlb.unifiedrendering.TagRenderer;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IRasterLayoutItem;
import com.sapportals.htmlb.unifiedrendering.controls.RasterLayout;
import com.sapportals.htmlb.unifiedrendering.enum.RasterLayoutPosition;
import java.io.PrintWriter;
import java.util.List;
import java.util.ListIterator;

public class RasterLayoutRenderer
extends AtomHtmlbRenderer {
    private static List textKeys = UrUtil.getUrTextKeys("RASTERLAYOUT");

    public void render(Component component, IPageContext manager) {
        RasterLayout pControl = new RasterLayout(component, manager);
        int x = 0;
        while (x < textKeys.size()) {
            manager.getDocument().registerStandardText((String)textKeys.get(x));
            ++x;
        }
        manager.registerStylesheet("ur_fc");
        this.renderRasterLayoutFragment(pControl, manager, pControl.getId(), pControl.getRasterHeight(), pControl.getRasterHeightUnit(), pControl.getRasterWidth(), pControl.getRasterWidthUnit(), pControl.getCompression(), pControl.getItems(), pControl.getPosition());
    }

    public void renderRasterLayoutFragment(IUIElement pControl, IPageContext manager, String pId, float pRasterHeight, String pRasterHeightUnit, float pRasterWidth, String pRasterWidthUnit, boolean pCompression, IURCollection pItems, RasterLayoutPosition pPosition) {
        PrintWriter out = (PrintWriter)manager.getWriter();
        StringBuffer _style_collector = new StringBuffer();
        boolean encode = false;
        TagRenderer.writeBeginTag(out, "div");
        _style_collector = new StringBuffer();
        String attribute = pId;
        if (!"".equals(attribute)) {
            TagRenderer.writeAttribute(out, "id", attribute, encode);
        }
        attribute = "RasterLayout";
        TagRenderer.writeAttribute(out, "ct", attribute, encode);
        if (pPosition == RasterLayoutPosition.ABSOLUTE) {
            attribute = "absolute";
            _style_collector.append("position:").append(attribute).append(";");
        } else if (pPosition == RasterLayoutPosition.RELATIVE) {
            attribute = "relative";
            _style_collector.append("position:").append(attribute).append(";");
        }
        if (_style_collector.length() != 0) {
            TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
        }
        TagRenderer.writeTagRightChar(out);
        ListIterator iter = pItems.getListIterator();
        while (iter.hasNext()) {
            IRasterLayoutItem pItem = (IRasterLayoutItem)iter.next();
            this.renderRasterLayoutItemFragment(pControl, manager, (float)pItem.getTop() * pRasterHeight + pRasterHeightUnit, (float)pItem.getLeft() * pRasterWidth + pRasterWidthUnit, (float)pItem.getWidth() * pRasterWidth + pRasterWidthUnit, (float)pItem.getHeight() * pRasterHeight + pRasterHeightUnit, pItem.getContent(), pItem.getId(), pItem.getPosition());
        }
        TagRenderer.writeEndTag(out, "div");
    }

    public void renderRasterLayoutItemFragment(IUIElement pControl, IPageContext manager, String pTop, String pLeft, String pWidth, String pHeight, IUIElement pContent, String pId, RasterLayoutPosition pPosition) {
        String attribute;
        PrintWriter out = (PrintWriter)manager.getWriter();
        StringBuffer _style_collector = new StringBuffer();
        boolean encode = false;
        TagRenderer.writeBeginTag(out, "div");
        _style_collector = new StringBuffer();
        if (manager.getHasAdvancedAlignment()) {
            attribute = "urVaRa";
            TagRenderer.writeAttribute(out, "class", attribute, encode);
        }
        if (pPosition == RasterLayoutPosition.ABSOLUTE) {
            attribute = "absolute";
            _style_collector.append("position:").append(attribute).append(";");
        } else if (pPosition == RasterLayoutPosition.RELATIVE) {
            attribute = "relative";
            _style_collector.append("position:").append(attribute).append(";");
        }
        attribute = pTop;
        if (!"".equals(attribute)) {
            _style_collector.append("top:").append(attribute).append(";");
        }
        if (manager.getIsRTL()) {
            attribute = pLeft;
            if (!"".equals(attribute)) {
                _style_collector.append("right:").append(attribute).append(";");
            }
        } else {
            attribute = pLeft;
            if (!"".equals(attribute)) {
                _style_collector.append("left:").append(attribute).append(";");
            }
        }
        attribute = pWidth;
        if (!"".equals(attribute)) {
            _style_collector.append("width:").append(attribute).append(";");
        }
        if (!"".equals(attribute = pHeight)) {
            _style_collector.append("height:").append(attribute).append(";");
        }
        if (_style_collector.length() != 0) {
            TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
        }
        TagRenderer.writeTagRightChar(out);
        RenderUtil.renderContentObject(pContent.getHtmlBControl(), manager);
        TagRenderer.writeEndTag(out, "div");
    }
}

