/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.ie5;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.IURCollection;
import com.sapportals.htmlb.unifiedrendering.TagRenderer;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IItemListItem;
import com.sapportals.htmlb.unifiedrendering.controls.ItemList;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.Visibility;
import java.io.PrintWriter;
import java.util.List;
import java.util.ListIterator;

public class ItemListRenderer
extends AtomHtmlbRenderer {
    private static List textKeys = UrUtil.getUrTextKeys("ITEMLIST");

    public void render(Component component, IPageContext manager) {
        ItemList pControl = new ItemList(component, manager);
        int x = 0;
        while (x < textKeys.size()) {
            manager.getDocument().registerStandardText((String)textKeys.get(x));
            ++x;
        }
        manager.registerStylesheet("ur_efc");
        this.renderItemListFragment(pControl, manager, pControl.getId(), pControl.getOrdered(), pControl.getItems(), pControl.getVisibility());
    }

    public void renderItemListFragment(IUIElement pControl, IPageContext manager, String pId, boolean pOrdered, IURCollection pItems, Visibility pVisibility) {
        ListIterator iter;
        PrintWriter out = (PrintWriter)manager.getWriter();
        StringBuffer _style_collector = new StringBuffer();
        boolean encode = false;
        TagRenderer.writeBeginTag(out, "div");
        _style_collector = new StringBuffer();
        String attribute = pId;
        TagRenderer.writeAttribute(out, "id", attribute, encode);
        attribute = "ItemList";
        TagRenderer.writeAttribute(out, "ct", attribute, encode);
        if (pVisibility == Visibility.BLANK) {
            attribute = "hidden";
            _style_collector.append("visibility:").append(attribute).append(";");
        }
        attribute = "urLicWhl";
        TagRenderer.writeAttribute(out, "class", attribute, encode);
        if (_style_collector.length() != 0) {
            TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
        }
        TagRenderer.writeTagRightChar(out);
        if (pOrdered) {
            TagRenderer.writeBeginTag(out, "ol");
            attribute = "urLic";
            TagRenderer.writeAttribute(out, "class", attribute, encode);
            TagRenderer.writeTagRightChar(out);
            iter = pItems.getListIterator();
            while (iter.hasNext()) {
                IItemListItem pItem = (IItemListItem)iter.next();
                this.renderItemListItemFragment(pControl, manager, pOrdered, pItem.getText(), pItem.getImageUrl(), pItem.getHasImageUrl(), pItem.getContent(), pItem.getIsControl(), pItem.getHasBulletStyle(), pItem.getBulletStyle(), pItem.getTextDirection());
            }
            TagRenderer.writeEndTag(out, "ol");
        } else {
            TagRenderer.writeBeginTag(out, "ul");
            attribute = "urLic";
            TagRenderer.writeAttribute(out, "class", attribute, encode);
            TagRenderer.writeTagRightChar(out);
            iter = pItems.getListIterator();
            while (iter.hasNext()) {
                IItemListItem pItem = (IItemListItem)iter.next();
                this.renderItemListItemFragment(pControl, manager, pOrdered, pItem.getText(), pItem.getImageUrl(), pItem.getHasImageUrl(), pItem.getContent(), pItem.getIsControl(), pItem.getHasBulletStyle(), pItem.getBulletStyle(), pItem.getTextDirection());
            }
            TagRenderer.writeEndTag(out, "ul");
        }
        TagRenderer.writeEndTag(out, "div");
    }

    public void renderItemListItemFragment(IUIElement pControl, IPageContext manager, boolean pOrdered, String pValue, String pImageUrl, boolean pHasImageUrl, IUIElement pContent, boolean pIsControl, boolean pHasBulletStyle, String pBulletStyle, ForcedTextDirection pTextDirection) {
        String attribute;
        PrintWriter out = (PrintWriter)manager.getWriter();
        StringBuffer _style_collector = new StringBuffer();
        boolean encode = false;
        TagRenderer.writeBeginTag(out, "li");
        _style_collector = new StringBuffer();
        if (manager.getIs508() && !pIsControl) {
            attribute = String.valueOf(0);
            TagRenderer.writeAttribute(out, "tabindex", attribute, encode);
            attribute = String.valueOf(0);
            TagRenderer.writeAttribute(out, "ti", attribute, encode);
        }
        if (!pOrdered) {
            if (pHasBulletStyle) {
                attribute = pBulletStyle;
                TagRenderer.writeAttribute(out, "class", attribute, encode);
            } else {
                attribute = "urLicItem";
                TagRenderer.writeAttribute(out, "class", attribute, encode);
            }
            if (pHasImageUrl && !"url()".equals(attribute = "url(" + pImageUrl + ")")) {
                _style_collector.append("list-style-image:").append(attribute).append(";");
            }
        }
        if (_style_collector.length() != 0) {
            TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
        }
        TagRenderer.writeTagRightChar(out);
        if (pIsControl) {
            TagRenderer.writeBeginTag(out, "span");
            TagRenderer.writeAttribute(out, "class", "urFontStd", encode);
            TagRenderer.writeTagRightChar(out);
            RenderUtil.renderContentObject(pContent.getHtmlBControl(), manager);
            TagRenderer.writeEndTag(out, "span");
        } else if (pTextDirection == ForcedTextDirection.LTR) {
            if (manager.getIsRTL()) {
                TagRenderer.writeBeginTag(out, "span");
                attribute = "ltr";
                TagRenderer.writeAttribute(out, "dir", attribute, encode);
                TagRenderer.writeTagRightChar(out);
                out.write(String.valueOf(pValue));
                TagRenderer.writeEndTag(out, "span");
            } else {
                out.write(String.valueOf(pValue));
            }
        } else if (pTextDirection == ForcedTextDirection.RTL) {
            if (!manager.getIsRTL()) {
                TagRenderer.writeBeginTag(out, "span");
                attribute = "rtl";
                TagRenderer.writeAttribute(out, "dir", attribute, encode);
                TagRenderer.writeTagRightChar(out);
                out.write(String.valueOf(pValue));
                TagRenderer.writeEndTag(out, "span");
            } else {
                out.write(String.valueOf(pValue));
            }
        } else {
            out.write(String.valueOf(pValue));
        }
        TagRenderer.writeEndTag(out, "li");
    }
}

