/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.ie5;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.InputField;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.rendering.ComponentValidationRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.defaultJavaScriptRenderer;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataString;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.TagRenderer;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.HorizontalAlign;
import com.sapportals.htmlb.unifiedrendering.enum.InputFieldFieldHelp;
import com.sapportals.htmlb.unifiedrendering.enum.InputFieldSize;
import com.sapportals.htmlb.unifiedrendering.enum.InputFieldType;
import com.sapportals.htmlb.unifiedrendering.enum.Visibility;
import com.sapportals.htmlb.valuehelp.DataTransferComponent;
import com.sapportals.htmlb.valuehelp.ValueHelpContext;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;

public class InputFieldRenderer
extends defaultJavaScriptRenderer {
    private static List textKeys = UrUtil.getUrTextKeys("FIELD");

    public InputFieldRenderer() {
        UrUtil.getUrTextKeys("F4FIELD", textKeys);
    }

    public void render(Component component, IPageContext manager) {
        ValueHelpContext valueHelpContext;
        com.sapportals.htmlb.unifiedrendering.controls.InputField pControl = new com.sapportals.htmlb.unifiedrendering.controls.InputField(component, manager);
        InputField inputField = (InputField)component;
        if (manager.isUsingSession() && !inputField.isVisible() && inputField.getParkInSession()) {
            String uniqueName = manager.getParamIdForComponent(inputField);
            Object value = inputField.getValue();
            String valueString = null;
            if (value != null) {
                if (value instanceof AbstractDataType) {
                    AbstractDataType dataValue = (AbstractDataType)value;
                    if (dataValue != null) {
                        valueString = dataValue.isValid() ? dataValue.toString(manager) : (dataValue instanceof DataString ? dataValue.toString(manager) : dataValue.getValueAsString());
                    }
                } else {
                    valueString = value.toString();
                }
            } else {
                valueString = "";
            }
            manager.getParamList().put(uniqueName, valueString);
            return;
        }
        HashSet<EventTrigger> validationTriggers = new HashSet<EventTrigger>();
        validationTriggers.add(EventTrigger.ON_BLUR);
        validationTriggers.add(EventTrigger.ON_CHANGE);
        ComponentValidationRenderer.renderEventValidationFunction(validationTriggers, (InputField)component, manager);
        if (inputField.isJsObjectNeeded()) {
            if (!inputField.isEnabled()) {
                inputField.setEnabled(true);
                manager.getCurrentForm().addForcedEnabledElement(manager.getParamIdForComponent(inputField), inputField);
            }
            manager.getCurrentForm().addForceJavascriptInterface(inputField, manager.getParamIdForComponent(inputField));
        }
        if ((valueHelpContext = inputField.getValueHelpContext()) != null) {
            DataTransferComponent dtc = valueHelpContext.getDataTransferComponent();
            if (inputField.isShowValueHelp() && dtc != null) {
                manager.render(dtc);
            }
        }
        if (pControl.getShowHelp()) {
            manager.getDocument().registerStandardText("SAPUR_JANUARY");
            manager.getDocument().registerStandardText("SAPUR_FEBRUARY");
            manager.getDocument().registerStandardText("SAPUR_MARCH");
            manager.getDocument().registerStandardText("SAPUR_APRIL");
            manager.getDocument().registerStandardText("SAPUR_MAY");
            manager.getDocument().registerStandardText("SAPUR_JUNE");
            manager.getDocument().registerStandardText("SAPUR_JULY");
            manager.getDocument().registerStandardText("SAPUR_AUGUST");
            manager.getDocument().registerStandardText("SAPUR_SEPTEMBER");
            manager.getDocument().registerStandardText("SAPUR_OCTOBER");
            manager.getDocument().registerStandardText("SAPUR_NOVEMBER");
            manager.getDocument().registerStandardText("SAPUR_DECEMBER");
            manager.getDocument().registerStandardText("SAPUR_FRIDAY_ABBREV");
            manager.getDocument().registerStandardText("SAPUR_MONDAY_ABBREV");
            manager.getDocument().registerStandardText("SAPUR_SATURDAY_ABBREV");
            manager.getDocument().registerStandardText("SAPUR_SUNDAY_ABBREV");
            manager.getDocument().registerStandardText("SAPUR_THURSDAY_ABBREV");
            manager.getDocument().registerStandardText("SAPUR_TUESDAY_ABBREV");
            manager.getDocument().registerStandardText("SAPUR_WEDNESDAY_ABBREV");
        }
        int x = 0;
        while (x < textKeys.size()) {
            manager.getDocument().registerStandardText((String)textKeys.get(x));
            ++x;
        }
        manager.registerStylesheet("ur_fc");
        this.renderInputFieldFragment(pControl, manager, pControl.getId(), pControl.getName(), pControl.getTooltip(), pControl.getValue(), pControl.getLength(), pControl.getMaxLength(), pControl.getInvalid(), pControl.getRequired(), pControl.getEnabled(), pControl.getReadonly(), pControl.getShowHelp(), pControl.getPasswordField(), pControl.getSize(), pControl.getType(), pControl.getFieldHelp(), pControl.getHidden(), pControl.getWidth(), pControl.getAlign(), pControl.getShowInputLength(), pControl.getTextDirection(), pControl.getVisibility(), pControl.getLabelText(), pControl.getHideFieldHelp(), pControl.getContainerWidthSet(), pControl.getUsedInSapTable());
        if (inputField.isJsObjectNeeded() && inputField.getType() == DataType.DATE) {
            SimpleDateFormat f = (SimpleDateFormat)DateFormat.getDateInstance(3, manager.getLocale());
            String pattern = f.toPattern().toString();
            manager.write("<script defer>document.getElementById('" + manager.getParamIdForComponent(inputField) + "').setAttribute('datep','" + pattern + "');</script>");
        }
    }

    public void renderInputFieldFragment(IUIElement pControl, IPageContext manager, String pId, String pName, String pTooltip, String pValue, int pLength, int pMaxLength, boolean pInvalid, boolean pRequired, boolean pEnabled, boolean pReadonly, boolean pShowHelp, boolean pPasswordField, InputFieldSize pSize, InputFieldType pType, InputFieldFieldHelp pFieldHelp, boolean pHidden, String pWidth, HorizontalAlign pAlign, boolean pShowInputLength, ForcedTextDirection pTextDirection, Visibility pVisibility, String pLabelText, boolean pHideFieldHelp, boolean pContainerWidthSet, boolean pUsedInSapTable) {
        PrintWriter out = (PrintWriter)manager.getWriter();
        StringBuffer _style_collector = new StringBuffer();
        boolean encode = false;
        if (pHidden) {
            CharSequence attribute;
            TagRenderer.writeBeginTag(out, "input");
            TagRenderer.writeAttribute(out, "type", "hidden", encode);
            _style_collector = new StringBuffer();
            if (pVisibility == Visibility.BLANK) {
                attribute = "hidden";
                _style_collector.append("visibility:").append((String)attribute).append(";");
            }
            if (!"".equals(attribute = pId)) {
                TagRenderer.writeAttribute(out, "id", (String)attribute, encode);
            }
            attribute = "InputField";
            TagRenderer.writeAttribute(out, "ct", (String)attribute, encode);
            attribute = new StringBuffer();
            if (!pName.equals("")) {
                ((StringBuffer)attribute).append(pName);
            } else {
                ((StringBuffer)attribute).append(pId);
            }
            TagRenderer.writeAttribute(out, "name", (StringBuffer)attribute, encode);
            attribute = pValue;
            if (!"".equals(attribute)) {
                TagRenderer.writeAttribute(out, "value", (String)attribute, encode);
            }
            if (_style_collector.length() != 0) {
                TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
            }
            TagRenderer.writeTagRightChar(out);
            TagRenderer.writeEndTag(out, "input");
        } else if (pWidth.equals("100%") || pUsedInSapTable) {
            CharSequence attribute;
            TagRenderer.writeBeginTag(out, "table");
            TagRenderer.writeAttribute(out, "cellpadding", "0", encode);
            TagRenderer.writeAttribute(out, "cellspacing", "0", encode);
            _style_collector = new StringBuffer();
            if (pVisibility == Visibility.BLANK) {
                attribute = "hidden";
                _style_collector.append("visibility:").append((String)attribute).append(";");
            }
            if (!"-r".equals(attribute = pId + "-r")) {
                TagRenderer.writeAttribute(out, "id", (String)attribute, encode);
            }
            attribute = "100%";
            _style_collector.append("width:").append((String)attribute).append(";");
            attribute = new StringBuffer();
            ((StringBuffer)attribute).append("urEdf2WhlTbl");
            if (pInvalid && pEnabled) {
                ((StringBuffer)attribute).append(" urEdf2WhlInv");
            }
            if (pEnabled && pReadonly) {
                ((StringBuffer)attribute).append(" urEdf2WhlRo");
            }
            if (!pEnabled) {
                ((StringBuffer)attribute).append(" urEdf2WhlDsbl");
            }
            TagRenderer.writeAttribute(out, "class", (StringBuffer)attribute, encode);
            if (pContainerWidthSet) {
                attribute = "fixed";
                _style_collector.append("table-layout:").append((String)attribute).append(";");
            }
            if (_style_collector.length() != 0) {
                TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
            }
            TagRenderer.writeTagRightChar(out);
            TagRenderer.writeBeginTag(out, "tr");
            TagRenderer.writeTagRightChar(out);
            TagRenderer.writeBeginTag(out, "td");
            TagRenderer.writeTagRightChar(out);
            this.renderInputFieldFieldFragment(pControl, manager, pId, pName, pTooltip, pValue, pLength, pMaxLength, pInvalid, pRequired, pEnabled, pReadonly, pShowHelp, pPasswordField, pSize, pType, pFieldHelp, pHidden, pWidth, pAlign, pShowInputLength, pTextDirection, pLabelText, pHideFieldHelp);
            TagRenderer.writeEndTag(out, "td");
            if (pShowHelp && !pPasswordField) {
                TagRenderer.writeBeginTag(out, "td");
                TagRenderer.writeAttribute(out, "class", "urEdf2BtnCnt", encode);
                TagRenderer.writeTagRightChar(out);
                this.renderInputFieldButtonFragment(pControl, manager, pId, pTooltip, pInvalid, pEnabled, pReadonly, pFieldHelp, pHideFieldHelp);
                TagRenderer.writeEndTag(out, "td");
            }
            TagRenderer.writeEndTag(out, "tr");
            TagRenderer.writeEndTag(out, "table");
        } else {
            String attribute;
            TagRenderer.writeBeginTag(out, "span");
            _style_collector = new StringBuffer();
            if (pVisibility == Visibility.BLANK) {
                attribute = "hidden";
                _style_collector.append("visibility:").append(attribute).append(";");
            }
            if (!"-r".equals(attribute = pId + "-r")) {
                TagRenderer.writeAttribute(out, "id", attribute, encode);
            }
            attribute = "urEdf2Whl";
            TagRenderer.writeAttribute(out, "class", attribute, encode);
            if (_style_collector.length() != 0) {
                TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
            }
            TagRenderer.writeTagRightChar(out);
            this.renderInputFieldFieldFragment(pControl, manager, pId, pName, pTooltip, pValue, pLength, pMaxLength, pInvalid, pRequired, pEnabled, pReadonly, pShowHelp, pPasswordField, pSize, pType, pFieldHelp, pHidden, pWidth, pAlign, pShowInputLength, pTextDirection, pLabelText, pHideFieldHelp);
            if (pShowHelp && !pPasswordField) {
                this.renderInputFieldButtonFragment(pControl, manager, pId, pTooltip, pInvalid, pEnabled, pReadonly, pFieldHelp, pHideFieldHelp);
            } else if (manager.getHasAdvancedAlignment()) {
                TagRenderer.writeBeginTag(out, "span");
                attribute = "urAr";
                TagRenderer.writeAttribute(out, "class", attribute, encode);
                TagRenderer.writeTagRightChar(out);
                TagRenderer.writeEndTag(out, "span");
            }
            TagRenderer.writeEndTag(out, "span");
        }
    }

    public void renderInputFieldFieldFragment(IUIElement pControl, IPageContext manager, String pId, String pName, String pTooltip, String pValue, int pLength, int pMaxLength, boolean pInvalid, boolean pRequired, boolean pEnabled, boolean pReadonly, boolean pShowHelp, boolean pPasswordField, InputFieldSize pSize, InputFieldType pType, InputFieldFieldHelp pFieldHelp, boolean pHidden, String pWidth, HorizontalAlign pAlign, boolean pShowInputLength, ForcedTextDirection pTextDirection, String pLabelText, boolean pHideFieldHelp) {
        CharSequence attribute;
        PrintWriter out = (PrintWriter)manager.getWriter();
        StringBuffer _style_collector = new StringBuffer();
        boolean encode = false;
        TagRenderer.writeBeginTag(out, "input");
        _style_collector = new StringBuffer();
        if (pPasswordField) {
            attribute = "Password";
            TagRenderer.writeAttribute(out, "type", (String)attribute, encode);
        } else {
            attribute = "Text";
            TagRenderer.writeAttribute(out, "type", (String)attribute, encode);
        }
        if (pTextDirection == ForcedTextDirection.LTR) {
            if (manager.getIsRTL()) {
                attribute = "ltr";
                TagRenderer.writeAttribute(out, "dir", (String)attribute, encode);
            }
        } else if (pTextDirection == ForcedTextDirection.RTL && !manager.getIsRTL()) {
            attribute = "rtl";
            TagRenderer.writeAttribute(out, "dir", (String)attribute, encode);
        }
        if (pAlign == HorizontalAlign.ENDOFLINE) {
            if (pTextDirection == ForcedTextDirection.LTR) {
                attribute = "right";
                _style_collector.append("text-align:").append((String)attribute).append(";");
            } else if (pTextDirection == ForcedTextDirection.RTL) {
                attribute = "left";
                _style_collector.append("text-align:").append((String)attribute).append(";");
            } else if (manager.getIsRTL()) {
                attribute = "left";
                _style_collector.append("text-align:").append((String)attribute).append(";");
            } else {
                attribute = "right";
                _style_collector.append("text-align:").append((String)attribute).append(";");
            }
        } else if (pAlign == HorizontalAlign.RIGHT) {
            if (manager.getIsRTL()) {
                if (pTextDirection == ForcedTextDirection.LTR) {
                    attribute = "right";
                    _style_collector.append("text-align:").append((String)attribute).append(";");
                }
            } else {
                attribute = "right";
                _style_collector.append("text-align:").append((String)attribute).append(";");
            }
        } else if (pAlign == HorizontalAlign.CENTER) {
            attribute = "center";
            _style_collector.append("text-align:").append((String)attribute).append(";");
        } else if (pAlign == HorizontalAlign.FORCEDLEFT) {
            if (manager.getIsRTL()) {
                attribute = "left";
                _style_collector.append("text-align:").append((String)attribute).append(";");
            } else if (pTextDirection == ForcedTextDirection.RTL) {
                attribute = "left";
                _style_collector.append("text-align:").append((String)attribute).append(";");
            }
        }
        attribute = pWidth;
        if (!"".equals(attribute)) {
            _style_collector.append("width:").append((String)attribute).append(";");
        }
        attribute = new StringBuffer();
        ((StringBuffer)attribute).append("urEdf2TxtEnbl");
        if (pInvalid && pEnabled && !pReadonly) {
            ((StringBuffer)attribute).append(" urEdf2TxtInv");
        }
        if (pEnabled && pReadonly) {
            ((StringBuffer)attribute).append(" urEdf2TxtRo");
        }
        if (!pEnabled) {
            ((StringBuffer)attribute).append(" urEdf2TxtDsbl");
        }
        if (manager.getHasAdvancedAlignment()) {
            ((StringBuffer)attribute).append(" urV");
        }
        TagRenderer.writeAttribute(out, "class", (StringBuffer)attribute, encode);
        attribute = "off";
        TagRenderer.writeAttribute(out, "autocomplete", (String)attribute, encode);
        attribute = String.valueOf(pLength);
        if (!String.valueOf(20).equals(attribute)) {
            TagRenderer.writeAttribute(out, "size", (String)attribute, encode);
        }
        attribute = String.valueOf(pMaxLength);
        if (!String.valueOf(0).equals(attribute)) {
            TagRenderer.writeAttribute(out, "maxlength", (String)attribute, encode);
        }
        attribute = String.valueOf(pShowInputLength);
        TagRenderer.writeAttribute(out, "showlength", (String)attribute, encode);
        attribute = pId;
        if (!"".equals(attribute)) {
            TagRenderer.writeAttribute(out, "id", (String)attribute, encode);
        }
        attribute = "InputField";
        TagRenderer.writeAttribute(out, "ct", (String)attribute, encode);
        attribute = new StringBuffer();
        if (!pName.equals("")) {
            ((StringBuffer)attribute).append(pName);
        } else {
            ((StringBuffer)attribute).append(pId);
        }
        TagRenderer.writeAttribute(out, "name", (StringBuffer)attribute, encode);
        attribute = new StringBuffer();
        if (pInvalid) {
            ((StringBuffer)attribute).append("i");
        }
        if (pRequired) {
            ((StringBuffer)attribute).append("m");
        }
        if (!pEnabled) {
            ((StringBuffer)attribute).append("d");
        }
        if (pReadonly) {
            ((StringBuffer)attribute).append("r");
        }
        TagRenderer.writeAttribute(out, "st", (StringBuffer)attribute, encode);
        if (manager.getIs508()) {
            attribute = pLabelText;
            if (!"".equals(attribute)) {
                TagRenderer.writeAttribute(out, "lbl", (String)attribute, encode);
            }
            if (!"".equals(attribute = pTooltip)) {
                TagRenderer.writeAttribute(out, "tt", (String)attribute, encode);
            }
            if (pPasswordField) {
                attribute = "PW";
                TagRenderer.writeAttribute(out, "tp", (String)attribute, encode);
            } else {
                attribute = String.valueOf(pType);
                TagRenderer.writeAttribute(out, "tp", (String)attribute, encode);
            }
            if (pShowHelp && pFieldHelp == InputFieldFieldHelp.F4LOOKUP) {
                attribute = String.valueOf(true);
                TagRenderer.writeAttribute(out, "f4", (String)attribute, encode);
            }
        }
        if (!pEnabled) {
            attribute = "";
            TagRenderer.writeAttribute(out, "readonly", (String)attribute, encode);
            if (!manager.getIs508()) {
                attribute = String.valueOf(-1);
                TagRenderer.writeAttribute(out, "tabindex", (String)attribute, encode);
                attribute = String.valueOf(-1);
                TagRenderer.writeAttribute(out, "ti", (String)attribute, encode);
            }
        } else if (pReadonly) {
            attribute = "";
            TagRenderer.writeAttribute(out, "readonly", (String)attribute, encode);
        }
        if (!"".equals(attribute = pTooltip)) {
            TagRenderer.writeAttribute(out, "title", (String)attribute, encode);
        }
        attribute = pValue;
        TagRenderer.writeAttribute(out, "value", (String)attribute, encode);
        String eventHandler = pControl.getJSEventFunction(ClientEvent.INPUTFIELDCHANGE, manager);
        if (eventHandler != null && eventHandler.length() > 0) {
            manager.write(" onchange=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if ((eventHandler = pControl.getJSEventFunction(ClientEvent.INPUTFIELDBLUR, manager)) != null && eventHandler.length() > 0) {
            manager.write(" onblur=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if ((eventHandler = pControl.getJSEventFunction(ClientEvent.INPUTFIELDKEYDOWN, manager)) != null && eventHandler.length() > 0) {
            manager.write(" onkeydown=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if ((eventHandler = pControl.getJSEventFunction(ClientEvent.INPUTFIELDKEYPRESS, manager)) != null && eventHandler.length() > 0) {
            manager.write(" onkeypress=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if ((eventHandler = pControl.getJSEventFunction(ClientEvent.INPUTFIELDKEYUP, manager)) != null && eventHandler.length() > 0) {
            manager.write(" onkeyup=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if ((eventHandler = pControl.getJSEventFunction(ClientEvent.INPUTFIELDFOCUS, manager)) != null && eventHandler.length() > 0) {
            manager.write(" onfocus=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if ((eventHandler = pControl.getJSEventFunction(ClientEvent.INPUTFIELDSELECTSTART, manager)) != null && eventHandler.length() > 0) {
            manager.write(" onselectstart=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if ((eventHandler = pControl.getJSEventFunction(ClientEvent.INPUTFIELDMOUSEUP, manager)) != null && eventHandler.length() > 0) {
            manager.write(" onmouseup=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if ((eventHandler = pControl.getJSEventFunction(ClientEvent.INPUTFIELDDBLCLICK, manager)) != null && eventHandler.length() > 0) {
            manager.write(" ondblclick=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if (_style_collector.length() != 0) {
            TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
        }
        TagRenderer.writeTagRightChar(out);
        TagRenderer.writeEndTag(out, "input");
    }

    public void renderInputFieldButtonFragment(IUIElement pControl, IPageContext manager, String pId, String pTooltip, boolean pInvalid, boolean pEnabled, boolean pReadonly, InputFieldFieldHelp pFieldHelp, boolean pHideFieldHelp) {
        CharSequence attribute;
        PrintWriter out = (PrintWriter)manager.getWriter();
        StringBuffer _style_collector = new StringBuffer();
        boolean encode = false;
        TagRenderer.writeBeginTag(out, "span");
        if (pEnabled && !pReadonly) {
            attribute = "urEdf2BtnBg";
            TagRenderer.writeAttribute(out, "class", (String)attribute, encode);
        } else {
            attribute = "urEdf2BtnBgDsbl";
            TagRenderer.writeAttribute(out, "class", (String)attribute, encode);
        }
        TagRenderer.writeTagRightChar(out);
        TagRenderer.writeBeginTag(out, "button");
        _style_collector = new StringBuffer();
        attribute = pId + "-btn";
        if (!"-btn".equals(attribute)) {
            TagRenderer.writeAttribute(out, "id", (String)attribute, encode);
        }
        attribute = "button";
        TagRenderer.writeAttribute(out, "type", (String)attribute, encode);
        if (pHideFieldHelp) {
            attribute = "absolute";
            _style_collector.append("position:").append((String)attribute).append(";");
            attribute = String.valueOf(-900);
            _style_collector.append("top:").append((String)attribute).append(";");
        }
        attribute = String.valueOf(-1);
        TagRenderer.writeAttribute(out, "tabindex", (String)attribute, encode);
        attribute = String.valueOf(-1);
        TagRenderer.writeAttribute(out, "ti", (String)attribute, encode);
        attribute = new StringBuffer();
        ((StringBuffer)attribute).append("urEdf2Hlp");
        if (pFieldHelp == InputFieldFieldHelp.CALENDAR) {
            ((StringBuffer)attribute).append("Date");
        } else if (pFieldHelp == InputFieldFieldHelp.F4LOOKUP) {
            ((StringBuffer)attribute).append("F4");
        } else if (pFieldHelp == InputFieldFieldHelp.CALCULATOR) {
            ((StringBuffer)attribute).append("Calc");
        }
        if (pReadonly || !pEnabled) {
            ((StringBuffer)attribute).append("Dsbl");
        }
        if (manager.getHasAdvancedAlignment()) {
            ((StringBuffer)attribute).append(" urV");
        }
        TagRenderer.writeAttribute(out, "class", (StringBuffer)attribute, encode);
        String eventHandler = pControl.getJSEventFunction(ClientEvent.INPUTFIELDFIELDHELPCLICK, manager);
        if (eventHandler != null && eventHandler.length() > 0) {
            manager.write(" onclick=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if ((eventHandler = pControl.getJSEventFunction(ClientEvent.INPUTFIELDKEYDOWN, manager)) != null && eventHandler.length() > 0) {
            manager.write(" onkeydown=\"");
            manager.write(eventHandler);
            manager.write("\" ");
        }
        if (_style_collector.length() != 0) {
            TagRenderer.writeAttribute(out, "style", _style_collector.toString(), encode);
        }
        TagRenderer.writeTagRightChar(out);
        TagRenderer.writeEndTag(out, "button");
        TagRenderer.writeEndTag(out, "span");
    }
}

