/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Tree;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.IURCollection;
import com.sapportals.htmlb.unifiedrendering.URCollection;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ITreeNode;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.TreeNodeDesign;
import com.sapportals.htmlb.unifiedrendering.enum.TreeNodeSelection;
import java.util.Enumeration;
import java.util.List;

public class TreeNode
extends UrControl
implements IUIElement,
ITreeNode {
    private com.sapportals.htmlb.TreeNode htmlbTreeNode;
    private IPageContext pc;
    private List children = null;
    private String componentId;
    private int nodeId;
    private int level;
    private String onTreeClick;

    public TreeNode(IPageContext pc, Tree tree, com.sapportals.htmlb.TreeNode component, int level) {
        this.pc = pc;
        this.htmlbTreeNode = component;
        this.componentId = pc.getParamIdForComponent(tree);
        this.nodeId = tree.getCurrentNodeId();
        tree.setCurrentNodeId(this.nodeId + 1);
        this.level = level;
        this.onTreeClick = tree.getOnTreeClick();
        this.children = new URCollection();
        Enumeration htmlbChildren = this.htmlbTreeNode.getChildNodes();
        while (htmlbChildren.hasMoreElements()) {
            com.sapportals.htmlb.TreeNode htmlbChild = (com.sapportals.htmlb.TreeNode)htmlbChildren.nextElement();
            TreeNode child = new TreeNode(pc, tree, htmlbChild, level + 1);
            this.children.add(child);
        }
    }

    public String getId() {
        return this.componentId.concat("-").concat(String.valueOf(this.nodeId));
    }

    public String getText() {
        if (this.htmlbTreeNode.getText() != null) {
            if (this.htmlbTreeNode.isEncode()) {
                return RenderUtil.encodeForHtml(this.htmlbTreeNode.getText());
            }
            return this.htmlbTreeNode.getText();
        }
        return "";
    }

    public int getLevel() {
        return this.level;
    }

    public boolean getHasChildren() {
        return this.htmlbTreeNode.hasChildren();
    }

    public boolean getIsOpen() {
        if (this.htmlbTreeNode.hasChildren()) {
            return this.htmlbTreeNode.isOpen();
        }
        return true;
    }

    public boolean getIsTextNode() {
        return this.htmlbTreeNode.getComponent() == null;
    }

    public String getTooltip() {
        return RenderUtil.encodeForHtml(this.htmlbTreeNode.getTooltip());
    }

    public IUIElement getContent() {
        return this;
    }

    public IURCollection getNodes() {
        return (IURCollection)((Object)this.children);
    }

    public boolean getIsClickable() {
        if (this.htmlbTreeNode.getOnNodeClick() != null && this.htmlbTreeNode.getOnNodeClick() != "") {
            return true;
        }
        return this.onTreeClick != null && this.onTreeClick != "";
    }

    public boolean getHasPopupMenu() {
        return this.htmlbTreeNode.getHoverMenu() != null;
    }

    public String getPopupMenuId() {
        if (this.htmlbTreeNode.getHoverMenu() != null) {
            if (this.htmlbTreeNode.getHoverMenu().getId() != null) {
                return this.pc.getParamIdForComponent(this.htmlbTreeNode.getHoverMenu());
            }
            return "";
        }
        return "";
    }

    public String getDisabledIconSrc() {
        return "";
    }

    public String getEnabledIconSrc() {
        return "";
    }

    public boolean getEnabled() {
        return true;
    }

    public boolean getIsCaptionNode() {
        return false;
    }

    public TreeNodeSelection getSelection() {
        return TreeNodeSelection.NONE;
    }

    public TreeNodeDesign getNodeDesign() {
        return TreeNodeDesign.STANDARD;
    }

    public Component getHtmlBControl() {
        return null;
    }

    public com.sapportals.htmlb.TreeNode getHtmlBTreeNode() {
        return this.htmlbTreeNode;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        pc.getLogLocation().debugT("TreeNode getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public ForcedTextDirection getTextDirection() {
        return UrUtil.matchAlignment(this.htmlbTreeNode.getTextDirection());
    }
}

