/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.HoverMenuTrigger;
import com.sapportals.htmlb.event.TreeNodeCloseEvent;
import com.sapportals.htmlb.event.TreeNodeExpandEvent;
import com.sapportals.htmlb.event.TreeNodeSelectEvent;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ITree;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ITreeNode;
import com.sapportals.htmlb.unifiedrendering.controls.TreeNode;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;

public class Tree
extends UrControl
implements IUIElement,
ITree {
    private com.sapportals.htmlb.Tree htmlbTree;
    private IPageContext pc;
    private TreeNode rootNode;

    public Tree(Component component, IPageContext pageContext) {
        if (component instanceof com.sapportals.htmlb.Tree) {
            this.htmlbTree = (com.sapportals.htmlb.Tree)component;
            this.pc = pageContext;
        }
        this.htmlbTree.setCurrentNodeId(1);
        this.rootNode = new TreeNode(this.pc, this.htmlbTree, this.htmlbTree.getRootNode(), 0);
    }

    public String getId() {
        return this.pc.getParamIdForComponent(this.htmlbTree);
    }

    public String getTitle() {
        if (this.htmlbTree.getTitle() != null) {
            return RenderUtil.encodeForHtml(this.htmlbTree.getTitle());
        }
        return "";
    }

    public boolean getTitleVisible() {
        return this.htmlbTree.getTitle() != null && this.htmlbTree.getTitle().length() > 0;
    }

    public boolean getRootNodeIsVisible() {
        return this.htmlbTree.isRootNodeVisible();
    }

    public String getTooltip() {
        if (this.htmlbTree.getTooltip() != null) {
            return RenderUtil.encodeForHtml(this.htmlbTree.getTooltip());
        }
        return "";
    }

    public int getNodeOffset() {
        return this.htmlbTree.getOffsetForTreeNode();
    }

    public String getMinHeight() {
        if (this.htmlbTree.getHeight() != null) {
            return this.htmlbTree.getHeight();
        }
        return "";
    }

    public ITreeNode getRoot() {
        return this.rootNode;
    }

    private String getNodeID(com.sapportals.htmlb.Tree tree, String componentID) {
        int nodeId = tree.getCurrentNodeId();
        tree.setCurrentNodeId(nodeId + 1);
        String id = String.valueOf(nodeId);
        return componentID.concat("-").concat(id);
    }

    public String getWidth() {
        return "100%";
    }

    public Component getHtmlBControl() {
        return this.htmlbTree;
    }

    public boolean getCanExpandAll() {
        return false;
    }

    public boolean getCanCollapseAll() {
        return false;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.TREEENTER) {
            return "sapUrMapi_Tree_enter('" + this.getId() + "',event);";
        }
        pc.getLogLocation().debugT("Tree getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public String getJSEventFunction(ClientEvent event, TreeNode node, IPageContext pc) {
        com.sapportals.htmlb.TreeNode htmlbNode = node.getHtmlBTreeNode();
        if (event == ClientEvent.TREENODETOGGLE) {
            if (htmlbNode.getOnNodeExpand() != null && !htmlbNode.getOnNodeExpand().equals("") && !htmlbNode.isOpen()) {
                return "htmlb_TreeToggle('" + this.getId() + "','" + node.getId() + "');" + TreeNodeExpandEvent.renderEventCall(pc, this.htmlbTree, htmlbNode);
            }
            if (htmlbNode.getOnNodeClose() != null && !htmlbNode.getOnNodeClose().equals("") && htmlbNode.isOpen()) {
                return "htmlb_TreeToggle('" + this.getId() + "','" + node.getId() + "');" + TreeNodeCloseEvent.renderEventCall(pc, this.htmlbTree, htmlbNode);
            }
            return "htmlb_TreeToggle('" + this.getId() + "','" + node.getId() + "');";
        }
        if (event == ClientEvent.TREENODECLICK) {
            if (this.htmlbTree.getOnTreeClick() != null && this.htmlbTree.getOnTreeClick() != "" || htmlbNode.getOnNodeClick() != null && htmlbNode.getOnNodeClick() != "") {
                return TreeNodeSelectEvent.renderEventCall(pc, this.htmlbTree, htmlbNode);
            }
            if (node.getHasPopupMenu() && (htmlbNode.getHoverMenu().getMenuTrigger() == HoverMenuTrigger.ONCLICK || htmlbNode.getHoverMenu().getMenuTrigger() == HoverMenuTrigger.ONLRCLICK || htmlbNode.getHoverMenu().getMenuTrigger() == null)) {
                return "htmlb_ShowPopupMenuOnNode('" + node.getId() + "','" + node.getPopupMenuId() + "','" + this.htmlbTree.getId() + "','" + htmlbNode.getID() + "',event)";
            }
            return "sapUrMapi_Tree_controlEnter('" + this.getId() + "','" + node.getId() + "',event)";
        }
        if (event == ClientEvent.TREENODEDRAGENTER) {
            if (node.getHasChildren()) {
                return "htmlb_TreeDragEnter('" + node.getId() + "');";
            }
            return "";
        }
        if (event == ClientEvent.TREENODEMOUSEOVER) {
            if (htmlbNode.getHoverMenu() != null && htmlbNode.getHoverMenu().getMenuTrigger() == HoverMenuTrigger.ONMOUSEOVER) {
                return "htmlb_ShowPopupMenuOnNode('" + node.getId() + "','" + node.getPopupMenuId() + "','" + this.htmlbTree.getId() + "','" + htmlbNode.getID() + "',event)";
            }
            return "";
        }
        if (event == ClientEvent.TREENODERIGHTCLICK) {
            if (htmlbNode.getHoverMenu() != null && (htmlbNode.getHoverMenu().getMenuTrigger() == HoverMenuTrigger.ONCONTEXTMENU || htmlbNode.getHoverMenu().getMenuTrigger() == HoverMenuTrigger.ONLRCLICK)) {
                return "htmlb_ShowPopupMenuOnNode('" + node.getId() + "','" + node.getPopupMenuId() + "','" + this.htmlbTree.getId() + "','" + htmlbNode.getID() + "',event);return false;";
            }
            return "";
        }
        if (event == ClientEvent.TREENODEKEYDOWN) {
            if (htmlbNode.getOnNodeExpand() != null && !htmlbNode.getOnNodeExpand().equals("") && !htmlbNode.isOpen()) {
                return "sapUrMapi_TreeNode_keyDown('" + this.getId() + "','" + node.getId() + "',event);if(htmlb_treenodeaction(event,false)) {" + TreeNodeExpandEvent.renderEventCall(pc, this.htmlbTree, htmlbNode) + "}";
            }
            if (htmlbNode.getOnNodeClose() != null && !htmlbNode.getOnNodeClose().equals("") && htmlbNode.isOpen()) {
                return "sapUrMapi_TreeNode_keyDown('" + this.getId() + "','" + node.getId() + "',event);if(htmlb_treenodeaction(event,true)) {" + TreeNodeCloseEvent.renderEventCall(pc, this.htmlbTree, htmlbNode) + "}";
            }
            return "sapUrMapi_TreeNode_keyDown('" + this.getId() + "','" + node.getId() + "',event);";
        }
        if (event == ClientEvent.TREENODECONTROLEXIT) {
            return "sapUrMapi_Tree_controlExit('" + this.getId() + "','" + node.getId() + "',event);";
        }
        if (event == ClientEvent.TREENODEMOUSEOVER) {
            return "sapUrMapi_TreeNode_hover('" + this.getId() + "','" + node.getId() + "',true,event);";
        }
        if (event == ClientEvent.TREENODEMOUSEOUT) {
            return "sapUrMapi_TreeNode_hover('" + this.getId() + "','" + node.getId() + "',false,event);";
        }
        if (event == ClientEvent.TREEENTER) {
            return "sapUrMapi_Tree_enter('" + this.getId() + "',event);";
        }
        pc.getLogLocation().debugT("Tree getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public boolean getEnabled() {
        return true;
    }

    public ForcedTextDirection getTextDirection() {
        return UrUtil.matchAlignment(this.htmlbTree.getTextDirection());
    }
}

