/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataString;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IToolbarInputField;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.HorizontalAlign;
import com.sapportals.htmlb.unifiedrendering.enum.InputFieldFieldHelp;

public class ToolbarInputField
extends UrControl
implements IUIElement,
IToolbarInputField {
    private com.sapportals.htmlb.toolbar.ToolbarInputField htmlbToolbarInputField;
    private IPageContext pc;

    public ToolbarInputField(Component component, IPageContext pageContext) {
        if (component instanceof com.sapportals.htmlb.toolbar.ToolbarInputField) {
            this.htmlbToolbarInputField = (com.sapportals.htmlb.toolbar.ToolbarInputField)component;
            this.pc = pageContext;
        }
    }

    public String getId() {
        return this.pc.getParamIdForComponent(this.htmlbToolbarInputField);
    }

    public String getName() {
        return this.pc.getParamIdForComponent(this.htmlbToolbarInputField);
    }

    public int getMaxLength() {
        return this.htmlbToolbarInputField.getMaxLength();
    }

    public int getLength() {
        return 20;
    }

    public boolean getEnabled() {
        return this.htmlbToolbarInputField.isEnabled();
    }

    public String getWidth() {
        if (this.htmlbToolbarInputField.getWidth() != null && this.htmlbToolbarInputField.getWidth().length() > 0) {
            return this.htmlbToolbarInputField.getWidth();
        }
        return "";
    }

    public String getValue() {
        Object value = this.htmlbToolbarInputField.getValue();
        String valueString = "";
        if (value != null) {
            if (value instanceof AbstractDataType) {
                AbstractDataType dataValue = (AbstractDataType)value;
                if (dataValue != null) {
                    if (dataValue.isValid()) {
                        if (this.htmlbToolbarInputField.getValueEncode()) {
                            return RenderUtil.encodeForHtml(dataValue.toString(this.pc));
                        }
                        return dataValue.toString(this.pc);
                    }
                    if (dataValue instanceof DataString) {
                        if (this.htmlbToolbarInputField.getValueEncode()) {
                            return RenderUtil.encodeForHtml(dataValue.toString(this.pc));
                        }
                        return dataValue.toString(this.pc);
                    }
                    if (this.htmlbToolbarInputField.getValueEncode()) {
                        return RenderUtil.encodeForHtml(dataValue.getValueAsString());
                    }
                    return dataValue.getValueAsString();
                }
            } else {
                if (this.htmlbToolbarInputField.getValueEncode()) {
                    return RenderUtil.encodeForHtml(value.toString());
                }
                return value.toString();
            }
            if (this.htmlbToolbarInputField.getValueEncode()) {
                return RenderUtil.encodeForHtml(valueString);
            }
            return valueString;
        }
        return "";
    }

    public boolean getShowLabel() {
        return this.htmlbToolbarInputField.getLabelText() != null && this.htmlbToolbarInputField.getLabelText().length() > 0;
    }

    public String getLabelText() {
        if (this.htmlbToolbarInputField.getLabelText() != null && this.htmlbToolbarInputField.getLabelText().length() > 0) {
            return RenderUtil.encodeForHtml(this.htmlbToolbarInputField.getLabelText());
        }
        return "";
    }

    public boolean getHasShowAlwaysState() {
        return false;
    }

    public boolean getShowAlways() {
        return false;
    }

    public String getTooltip() {
        return "";
    }

    public boolean getShow() {
        return true;
    }

    public Component getHtmlBControl() {
        return this.htmlbToolbarInputField;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.TOOLBARINPUTFIELDFOCUS) {
            return "sapUrMapi_InputField_focus('" + this.getId() + "',event);";
        }
        if (event == ClientEvent.TOOLBARINPUTFIELDKEYDOWN) {
            return "sapUrMapi_InputField_keydown('" + this.getId() + "',event);";
        }
        pc.getLogLocation().debugT("ToolbarInputField getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public HorizontalAlign getAlign() {
        return UrUtil.matchAlignment(this.htmlbToolbarInputField.getHAlign());
    }

    public boolean getInvalid() {
        return false;
    }

    public boolean getPasswordField() {
        return false;
    }

    public boolean getReadonly() {
        return false;
    }

    public InputFieldFieldHelp getFieldHelp() {
        return null;
    }

    public boolean getShowHelp() {
        return false;
    }

    public ForcedTextDirection getTextDirection() {
        return UrUtil.matchAlignment(this.htmlbToolbarInputField.getTextDirection());
    }
}

