/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.HoverMenuTrigger;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ITextView;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.HorizontalAlign;
import com.sapportals.htmlb.unifiedrendering.enum.TextViewDesign;
import com.sapportals.htmlb.unifiedrendering.enum.TextViewLayout;
import com.sapportals.htmlb.unifiedrendering.enum.TextViewSemanticColor;

public class TextView
extends UrControl
implements IUIElement,
ITextView {
    private com.sapportals.htmlb.TextView htmlbTextView;
    private IPageContext pc;

    public TextView(Component component, IPageContext pageContext) {
        if (component instanceof com.sapportals.htmlb.TextView) {
            this.htmlbTextView = (com.sapportals.htmlb.TextView)component;
            this.pc = pageContext;
        }
    }

    public String getId() {
        if (this.getHasPopupMenu() || this.pc.requiresSection508Rendering()) {
            return this.pc.getParamIdForComponent(this.htmlbTextView);
        }
        return "";
    }

    public String getText() {
        if (this.htmlbTextView.getText() != null) {
            if (this.htmlbTextView.isEncode()) {
                return RenderUtil.encodeForHtmlDisplay(this.htmlbTextView.getText());
            }
            return this.htmlbTextView.getText();
        }
        return "";
    }

    public String getTooltip() {
        if (this.htmlbTextView.getTooltip() != null) {
            return RenderUtil.encodeForHtml(this.htmlbTextView.getTooltip());
        }
        return "";
    }

    public boolean getWrapping() {
        return this.htmlbTextView.isWrapping();
    }

    public boolean getRequired() {
        return this.htmlbTextView.isRequired();
    }

    public TextViewDesign getDesign() {
        if (this.htmlbTextView.getDesign() != null) {
            return TextViewDesign.valueOf(this.htmlbTextView.getDesign().toString());
        }
        return TextViewDesign.STANDARD;
    }

    public TextViewLayout getLayout() {
        if (this.htmlbTextView.getLayout() != null) {
            return TextViewLayout.valueOf(this.htmlbTextView.getLayout().toString());
        }
        return TextViewLayout.NATIVE;
    }

    public boolean getEncode() {
        return this.htmlbTextView.isEncode();
    }

    public String getWidth() {
        if (this.htmlbTextView.getWidth() != null) {
            return this.htmlbTextView.getWidth();
        }
        return "";
    }

    public String getPopupMenuId() {
        if (this.htmlbTextView.getHoverMenu() != null) {
            if (this.htmlbTextView.getHoverMenu().getId() != null) {
                return this.pc.getParamIdForComponent(this.htmlbTextView.getHoverMenu());
            }
            return "";
        }
        return "";
    }

    public boolean getHasPopupMenu() {
        return this.htmlbTextView.getHoverMenu() != null;
    }

    public boolean getIsNested() {
        return this.htmlbTextView.isNested();
    }

    public Component getHtmlBControl() {
        return this.htmlbTextView;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (this.getHasPopupMenu()) {
            if (event == ClientEvent.TEXTVIEWCLICK) {
                if (this.htmlbTextView.getHoverMenu().getMenuTrigger() == HoverMenuTrigger.ONCLICK || this.htmlbTextView.getHoverMenu().getMenuTrigger() == HoverMenuTrigger.ONLRCLICK || this.htmlbTextView.getHoverMenu().getMenuTrigger() == null) {
                    return "htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbTextView.getId() + "',event)";
                }
                return "";
            }
            if (event == ClientEvent.TEXTVIEWMOUSEOVER) {
                if (this.htmlbTextView.getHoverMenu().getMenuTrigger() == HoverMenuTrigger.ONMOUSEOVER) {
                    return "htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbTextView.getId() + "',event)";
                }
                return "";
            }
            if (event == ClientEvent.TEXTVIEWRIGHTCLICK) {
                if (this.htmlbTextView.getHoverMenu().getMenuTrigger() == HoverMenuTrigger.ONCONTEXTMENU || this.htmlbTextView.getHoverMenu().getMenuTrigger() == HoverMenuTrigger.ONLRCLICK) {
                    return "htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbTextView.getId() + "',event);return false;";
                }
                return "";
            }
            if (event == ClientEvent.TEXTVIEWKEYDOWN) {
                StringBuffer f = new StringBuffer();
                f.append("if (sapUrMapi_Link_activate('" + this.getId() + "',event)) { ");
                f.append("htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbTextView.getId() + "',event)");
                f.append(" };");
                return f.toString();
            }
            if (event == ClientEvent.TEXTVIEWFOCUS) {
                return "sapUrMapi_TextView_focus('" + this.getId() + "',event);";
            }
            pc.getLogLocation().debugT("TextView getJsEventFunction: ", "Event " + event.toString() + " not handled");
            return "";
        }
        if (event == ClientEvent.TEXTVIEWFOCUS) {
            return "sapUrMapi_TextView_focus('" + this.getId() + "',event);";
        }
        pc.getLogLocation().debugT("TextView getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public HorizontalAlign getAlign() {
        return UrUtil.matchAlignment(this.htmlbTextView.getHAlign());
    }

    public TextViewSemanticColor getSemanticColor() {
        return TextViewSemanticColor.DEFAULT;
    }

    public String getTextForTooltip() {
        if (this.htmlbTextView.isEncode()) {
            return RenderUtil.encodeForHtmlDisplay(this.htmlbTextView.getText());
        }
        return RenderUtil.encodeForHtmlDisplay(UrUtil.eliminateTags(this.htmlbTextView.getText()));
    }

    public ForcedTextDirection getTextDirection() {
        return UrUtil.matchAlignment(this.htmlbTextView.getTextDirection());
    }
}

