/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.table.SpanInfo;
import com.sapportals.htmlb.table.TableView;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.IURCollection;
import com.sapportals.htmlb.unifiedrendering.URCollection;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ITableViewRow;
import com.sapportals.htmlb.unifiedrendering.controls.TableViewCell;
import java.util.List;

public class TableViewRow
implements ITableViewRow {
    List cells = new URCollection();
    int row;
    boolean isStandardRow;
    boolean isSelected;
    boolean isSelectable;
    int visibleFirstRow;
    String rowDescription = "";
    static /* synthetic */ Class class$com$sapportals$htmlb$table$DefaultRowRenderer;

    public TableViewRow(TableView tableView, int row, String tvId) {
        this.row = row;
        this.visibleFirstRow = tableView.getVisibleFirstRow();
        int i = 0;
        while (i < tableView.getColumnCount()) {
            TableViewCell cell;
            SpanInfo spanInfo = tableView.getSpanInfoForCell(row, i + 1);
            if (spanInfo != null) {
                if (spanInfo.rowspan > 1 && spanInfo.originalRow == row && spanInfo.originalColumn == i + 1 || row == tableView.getVisibleFirstRow()) {
                    cell = new TableViewCell(tableView, row, i + 1, tvId);
                    if (spanInfo.colspan > 1) {
                        i = i + spanInfo.colspan - 1;
                    }
                    this.cells.add(cell);
                } else if (spanInfo.colspan > 1) {
                    i = i + spanInfo.colspan - 1;
                }
            } else {
                cell = new TableViewCell(tableView, row, i + 1, tvId);
                if (cell.getColspan() > 1) {
                    i = i + cell.getColspan() - 1;
                }
                this.cells.add(cell);
            }
            ++i;
        }
        this.isSelected = tableView.isRowSelected(row);
        this.isStandardRow = tableView.getRowRenderer(row) == null || tableView.getRowRenderer(row).getClass() == (class$com$sapportals$htmlb$table$DefaultRowRenderer == null ? (class$com$sapportals$htmlb$table$DefaultRowRenderer = TableViewRow.class$("com.sapportals.htmlb.table.DefaultRowRenderer")) : class$com$sapportals$htmlb$table$DefaultRowRenderer);
        this.isSelectable = tableView.isRowSelectable(row);
        this.rowDescription = RenderUtil.encodeForHtml(tableView.getRowDescription(row));
    }

    public boolean getIsSelected() {
        return this.isSelected;
    }

    public boolean getIsSelectable() {
        return this.isSelectable;
    }

    public IURCollection getCells() {
        return (IURCollection)((Object)this.cells);
    }

    public int getIndex() {
        return this.row - this.visibleFirstRow + 1;
    }

    public boolean getIsStandardRow() {
        return this.isStandardRow;
    }

    public IUIElement getRowContent() {
        return null;
    }

    public String getRowDescription() {
        return this.rowDescription;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

