/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ICaption;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ITableViewHeaderCell;
import com.sapportals.htmlb.unifiedrendering.enum.CellHAlign;
import com.sapportals.htmlb.unifiedrendering.enum.CellVAlign;
import com.sapportals.htmlb.unifiedrendering.enum.SortState;

public class TableViewHeaderCell
implements ITableViewHeaderCell {
    private String caption;
    private CellHAlign hAlign;
    private CellVAlign vAlign;
    private boolean isTextHeader;
    private boolean isClickable;
    private String tooltip;
    private String width;
    private SortState sortState;
    private boolean isWrapping;
    private String tableViewId;
    private int col;

    public TableViewHeaderCell(String caption, CellHAlign hAlign, CellVAlign vAlign, boolean isTextHeader, boolean isClickable, String tooltip, String width, SortState sortState, boolean isWrapping, String tvId, int col) {
        this.caption = caption;
        this.hAlign = hAlign;
        this.vAlign = vAlign;
        this.isTextHeader = isTextHeader;
        this.isClickable = isClickable;
        this.tooltip = tooltip;
        this.width = width;
        this.sortState = sortState;
        this.isWrapping = isWrapping;
        this.tableViewId = tvId;
        this.col = col;
    }

    public String getCaption() {
        if (this.caption.length() > 0) {
            return this.caption;
        }
        return "&nbsp;";
    }

    public String getId() {
        return this.tableViewId + "H" + this.col;
    }

    public boolean getIsTextHeader() {
        return this.isTextHeader;
    }

    public IUIElement getHeaderContent() {
        return null;
    }

    public CellHAlign getHAlign() {
        return this.hAlign;
    }

    public CellVAlign getVAlign() {
        return this.vAlign;
    }

    public boolean getIsClickable() {
        return this.isClickable;
    }

    public String getTooltip() {
        return RenderUtil.encodeForHtml(this.tooltip);
    }

    public String getWidth() {
        if (this.width != null) {
            return this.width;
        }
        return "";
    }

    public boolean getHasHeaderCaption() {
        return false;
    }

    public ICaption getHeaderCaption() {
        return null;
    }

    public SortState getSortState() {
        return this.sortState;
    }

    public boolean getWrapping() {
        return this.isWrapping;
    }
}

