/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.TableColumnType;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.table.SpanInfo;
import com.sapportals.htmlb.table.TableView;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ITableViewCell;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.CellHAlign;
import com.sapportals.htmlb.unifiedrendering.enum.CellVAlign;
import com.sapportals.htmlb.unifiedrendering.enum.TableViewCellPosition;
import com.sapportals.htmlb.unifiedrendering.enum.TableViewCellSemanticColor;
import com.sapportals.htmlb.unifiedrendering.enum.TableViewCellType;

public class TableViewCell
extends UrControl
implements ITableViewCell {
    private TableView htmlbTableView;
    private int row;
    private int column;
    private String tableViewId;

    public TableViewCell(TableView table, int row, int column, String tvId) {
        this.htmlbTableView = table;
        this.row = row;
        this.column = column;
        this.tableViewId = tvId;
    }

    public TableViewCellPosition getPosition() {
        return TableViewCellPosition.STANDARD;
    }

    public TableViewCellSemanticColor getSemanticColor() {
        if (this.htmlbTableView.getStyleForCell(this.row, this.column) != null) {
            return TableViewCellSemanticColor.valueOf(this.htmlbTableView.getStyleForCell(this.row, this.column).toString());
        }
        return TableViewCellSemanticColor.STANDARD;
    }

    public IUIElement getContent() {
        return null;
    }

    public CellHAlign getHAlign() {
        if (this.htmlbTableView.getCellHAlignment(this.row, this.column) != null) {
            return CellHAlign.valueOf(this.htmlbTableView.getCellHAlignment(this.row, this.column).toString());
        }
        if (this.htmlbTableView.getColumn(this.column).getDataType() != null && (this.htmlbTableView.getColumn(this.column).getDataType().equals(DataType.BCD) || this.htmlbTableView.getColumn(this.column).getDataType().equals(DataType.INTEGER))) {
            return CellHAlign.RIGHT;
        }
        return CellHAlign.LEFT;
    }

    public CellVAlign getVAlign() {
        if (this.htmlbTableView.getCellVAlignment(this.row, this.column) != null) {
            return CellVAlign.valueOf(this.htmlbTableView.getCellVAlignment(this.row, this.column).toString());
        }
        return CellVAlign.MIDDLE;
    }

    public int getCurrentRow() {
        return this.row - this.htmlbTableView.getVisibleFirstRow() + 1;
    }

    public int getCurrentColumn() {
        return this.column;
    }

    public int getRowspan() {
        SpanInfo spanInfo = this.htmlbTableView.getSpanInfoForCell(this.row, this.column);
        if (spanInfo != null) {
            return spanInfo.rowspan;
        }
        return this.htmlbTableView.getRowspanForCell(this.row, this.column);
    }

    public int getColspan() {
        if (this.row == 1 && this.column == 1 && this.htmlbTableView.getEmptyTableText() != null && this.htmlbTableView.getRowCount() == 0) {
            return this.htmlbTableView.getColumnCount();
        }
        SpanInfo spanInfo = this.htmlbTableView.getSpanInfoForCell(this.row, this.column);
        if (spanInfo != null) {
            return spanInfo.colspan;
        }
        return this.htmlbTableView.getColspanForCell(this.row, this.column);
    }

    public String getWidth() {
        if (this.row == 1 && this.column == 1 && this.htmlbTableView.getEmptyTableText() != null && this.htmlbTableView.getRowCount() == 0) {
            return "";
        }
        if (this.htmlbTableView.getColumn(this.column) != null) {
            if (this.htmlbTableView.getColumn(this.column).getWidth() != null) {
                return this.htmlbTableView.getColumn(this.column).getWidth();
            }
            return "";
        }
        return "";
    }

    public TableViewCellType getCellType() {
        TableColumnType type = this.htmlbTableView.getCellType(this.row, this.column);
        if (type != null) {
            if (type == TableColumnType.TEXT || type == TableColumnType.LINK) {
                return TableViewCellType.DISPLAY;
            }
            return TableViewCellType.EDIT;
        }
        return TableViewCellType.DISPLAY;
    }

    public String getTooltip() {
        String tooltipColumn = this.htmlbTableView.getColumn(this.column).getTooltipColumnKey();
        String tooltip = this.row <= this.htmlbTableView.getRowCount() && this.htmlbTableView.getCurrentRowIndex() <= this.htmlbTableView.getRowCount() && tooltipColumn != null && tooltipColumn.length() > 0 ? this.htmlbTableView.getValueAt(this.row, tooltipColumn).toString() : "";
        return RenderUtil.encodeForHtml(tooltip);
    }

    public boolean getIsClickable() {
        String onCellClick = this.htmlbTableView.getColumn(this.column).getOnCellClick();
        String onClientCellClick = this.htmlbTableView.getColumn(this.column).getOnClientCellClick();
        return onCellClick != null && onCellClick.length() > 0 || onClientCellClick != null && onClientCellClick.length() > 0;
    }

    public String getHeaderCellIds() {
        return this.tableViewId + "H" + this.column;
    }
}

