/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.TabStripItem;
import com.sapportals.htmlb.enum.BrowserType;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.IURCollection;
import com.sapportals.htmlb.unifiedrendering.URCollection;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ITabStrip;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.CellHAlign;
import com.sapportals.htmlb.unifiedrendering.enum.CellVAlign;
import java.util.Iterator;
import java.util.List;

public class TabStrip
extends UrControl
implements IUIElement,
ITabStrip {
    private com.sapportals.htmlb.TabStrip htmlbTabStrip;
    private IPageContext pc;
    private List items = null;
    private int currentIndex = 0;

    public TabStrip(Component component, IPageContext pageContext) {
        if (component instanceof com.sapportals.htmlb.TabStrip) {
            this.htmlbTabStrip = (com.sapportals.htmlb.TabStrip)component;
            this.pc = pageContext;
            Iterator htmlbItems = this.htmlbTabStrip.getItems().values();
            this.items = new URCollection();
            int i = 0;
            while (htmlbItems.hasNext()) {
                TabStripItem myItem = (TabStripItem)htmlbItems.next();
                if (this.htmlbTabStrip.getSelection() == myItem.getIndex()) {
                    this.currentIndex = i;
                }
                com.sapportals.htmlb.unifiedrendering.controls.TabStripItem item = new com.sapportals.htmlb.unifiedrendering.controls.TabStripItem(i, myItem, this.htmlbTabStrip, pageContext);
                this.items.add(item);
                ++i;
            }
        }
    }

    public String getId() {
        return this.pc.getParamIdForComponent(this.htmlbTabStrip);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public String getHeight() {
        if (this.htmlbTabStrip.getBodyHeight() != null) {
            if ((this.pc.getBrowserId() == BrowserType.NETSCAPE_4 || this.pc.getBrowserId() == BrowserType.NETSCAPE_6 || this.pc.getBrowserId() == BrowserType.NETSCAPE_7 || this.pc.getBrowserId() == BrowserType.MAC_NETSCAPE_4 || this.pc.getBrowserId() == BrowserType.MAC_NETSCAPE_6) && this.htmlbTabStrip.getBodyHeight().indexOf("%") >= 0) {
                return "";
            }
            return RenderUtil.encodeForHtmlDisplay(this.htmlbTabStrip.getBodyHeight());
        }
        return "";
    }

    public String getWidth() {
        if (this.htmlbTabStrip.getWidth() != null) {
            return RenderUtil.encodeForHtmlDisplay(this.htmlbTabStrip.getWidth());
        }
        return "";
    }

    public CellHAlign getHAlign() {
        if (this.htmlbTabStrip.getHAlign() != null) {
            return CellHAlign.valueOf(this.htmlbTabStrip.getHAlign().toString());
        }
        return CellHAlign.CENTER;
    }

    public CellVAlign getVAlign() {
        if (this.htmlbTabStrip.getVAlign() != null) {
            return CellVAlign.valueOf(this.htmlbTabStrip.getVAlign().toString());
        }
        return CellVAlign.MIDDLE;
    }

    public String getTooltip() {
        if (this.htmlbTabStrip.getTooltip() != null) {
            return RenderUtil.encodeForHtml(this.htmlbTabStrip.getTooltip());
        }
        return "";
    }

    public IURCollection getItems() {
        return (IURCollection)((Object)this.items);
    }

    public Component getHtmlBControl() {
        return this.htmlbTabStrip;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.TABSTRIPCREATE) {
            return "sapUrMapi_TabStrip_RegisterCreate('" + this.getId() + "'," + this.items.size() + ",'" + this.getCurrentIndex() + "');";
        }
        if (event == ClientEvent.TABSTRIPENTER) {
            return "sapUrMapi_TabStrip_enter('" + this.getId() + "',event);";
        }
        if (event == ClientEvent.SKIPCONTAINER) {
            return "sapUrMapi_skip('" + this.getId() + "',event);";
        }
        pc.getLogLocation().debugT("TabStrip getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public String getAccessibilityDescription() {
        return RenderUtil.encodeForHtml(this.htmlbTabStrip.getAccessibilityDescription());
    }

    public boolean getExactTabAlignment() {
        return true;
    }
}

