/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.RoadMapItemDesign;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IRoadMapItem;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.RoadMapStepDesign;
import com.sapportals.htmlb.unifiedrendering.enum.RoadMapStepType;

public class RoadMapItem
extends UrControl
implements IUIElement,
IRoadMapItem {
    private com.sapportals.htmlb.RoadMapItem htmlbRoadItem;
    private IPageContext pc;

    public RoadMapItem(Component component, IPageContext pageContext) {
        if (component instanceof com.sapportals.htmlb.RoadMapItem) {
            this.htmlbRoadItem = (com.sapportals.htmlb.RoadMapItem)component;
            this.pc = pageContext;
        }
    }

    public int getItemIndex() {
        return this.htmlbRoadItem.getIndex() - 1;
    }

    public String getTooltip() {
        return RenderUtil.encodeForHtml(this.htmlbRoadItem.getTooltip());
    }

    public String getTitle() {
        return RenderUtil.encodeForHtml(this.htmlbRoadItem.getID());
    }

    public RoadMapStepDesign getStepDesign() {
        if (this.htmlbRoadItem.getDesign() == RoadMapItemDesign.DEFAULT) {
            return RoadMapStepDesign.DEFAULT;
        }
        if (this.htmlbRoadItem.getDesign() == RoadMapItemDesign.DISABLED) {
            return RoadMapStepDesign.DISABLED;
        }
        if (this.htmlbRoadItem.getDesign() == RoadMapItemDesign.ROUNDTRIP) {
            return RoadMapStepDesign.ROUNDTRIP;
        }
        if (this.htmlbRoadItem.getDesign() == RoadMapItemDesign.SELECTED) {
            return RoadMapStepDesign.SELECTED;
        }
        return RoadMapStepDesign.DEFAULT;
    }

    public boolean getIsInteractive() {
        return this.htmlbRoadItem.getInteractive();
    }

    public String getStepName() {
        return RenderUtil.encodeForHtml(this.htmlbRoadItem.getStepName());
    }

    public String getStepDescription() {
        return RenderUtil.encodeForHtml(this.htmlbRoadItem.getDescription());
    }

    public Component getHtmlBControl() {
        return this.htmlbRoadItem;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        pc.getLogLocation().debugT("RoadMapItem getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public String getId() {
        return this.pc.getParamIdForComponent(this.htmlbRoadItem);
    }

    public RoadMapStepType getStepType() {
        return RoadMapStepType.STANDARDSTEP;
    }

    public boolean getDynamicStep() {
        return false;
    }

    public ForcedTextDirection getTextDirection() {
        return UrUtil.matchAlignment(this.htmlbRoadItem.getTextDirection());
    }
}

