/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IPopupTrigger;
import com.sapportals.htmlb.unifiedrendering.controls.Image;
import com.sapportals.htmlb.unifiedrendering.controls.TextView;

public class PopupTrigger
implements IPopupTrigger,
IUIElement {
    private com.sapportals.htmlb.PopupTrigger htmlbPopupTrigger;
    private IPageContext pageContext;

    public PopupTrigger(Component component, IPageContext manager) {
        if (component instanceof com.sapportals.htmlb.PopupTrigger) {
            this.htmlbPopupTrigger = (com.sapportals.htmlb.PopupTrigger)component;
            this.pageContext = manager;
            Component popupTriggerContent = this.htmlbPopupTrigger.getContent();
            if (popupTriggerContent instanceof com.sapportals.htmlb.Image) {
                com.sapportals.htmlb.Image image = (com.sapportals.htmlb.Image)popupTriggerContent;
                HoverMenu menu = image.getHoverMenu();
                if (menu != null) {
                    image.removerHoverMenu(menu);
                }
                Image content = new Image(image, manager);
            } else if (popupTriggerContent instanceof com.sapportals.htmlb.TextView) {
                com.sapportals.htmlb.TextView text = (com.sapportals.htmlb.TextView)popupTriggerContent;
                HoverMenu menu = text.getHoverMenu();
                if (menu != null) {
                    text.removerHoverMenu(menu);
                }
                TextView textView = new TextView(text, manager);
            }
        }
    }

    public String getId() {
        return this.pageContext.getParamIdForComponent(this.htmlbPopupTrigger);
    }

    public String getTooltip() {
        return this.htmlbPopupTrigger.getTooltip();
    }

    public boolean getHasContent() {
        return ((com.sapportals.htmlb.PopupTrigger)this.getHtmlBControl()).getContent() != null;
    }

    public IUIElement getContent() {
        return this;
    }

    public boolean getIsInteractive() {
        return this.htmlbPopupTrigger.isInteractive();
    }

    public boolean getHasPopupMenu() {
        return true;
    }

    public String getPopupMenuId() {
        return this.pageContext.getParamIdForComponent(this.htmlbPopupTrigger.getMenu());
    }

    public Component getHtmlBControl() {
        return this.htmlbPopupTrigger;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.POPUPTRIGGERHOVER) {
            return "htmlbPopupTriggerOver('" + this.getId() + "', event);";
        }
        if (event == ClientEvent.POPUPTRIGGEROPENMENU) {
            return "htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbPopupTrigger.getId() + "',event)";
        }
        if (event == ClientEvent.POPUPTRIGGERCREATE) {
            return "sapUrMapi_PopupTrigger_init('" + this.getId() + "')";
        }
        pc.getLogLocation().debugT("PopupTrigger getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }
}

