/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.event.HoverItemClickEvent;
import com.sapportals.htmlb.hovermenu.HoverMenuItem;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IPopupMenuItem;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;

public class PopupMenuItem
extends UrControl
implements IUIElement,
IPopupMenuItem {
    private HoverMenuItem htmlbItem;
    private String id;
    private String subMenuId;
    private int index;

    public PopupMenuItem(HoverMenuItem item, String id, String subMenuId, int index) {
        this.htmlbItem = item;
        this.id = id;
        this.subMenuId = subMenuId;
        this.index = index;
    }

    public String getId() {
        return this.id;
    }

    public String getSubMenuId() {
        if (this.htmlbItem.getSubMenu() != null) {
            return this.subMenuId;
        }
        return "";
    }

    public String getText() {
        if (this.htmlbItem.getText() != null) {
            return RenderUtil.encodeForHtml(this.htmlbItem.getText());
        }
        return "";
    }

    public boolean getChecked() {
        return this.htmlbItem.isChecked();
    }

    public boolean getHasSubMenu() {
        return this.htmlbItem.getSubMenu() != null;
    }

    public boolean getCanCheck() {
        return this.htmlbItem.isCheckable();
    }

    public boolean getHasSeparator() {
        return this.htmlbItem.hasHoverItemDivider() && this.index > 0;
    }

    public boolean getEnabled() {
        return !this.htmlbItem.isDisabled();
    }

    public boolean getIsLink() {
        return this.htmlbItem.getLinkReference() != null && this.htmlbItem.getLinkReference().length() > 0;
    }

    public String getLinkReference() {
        if (this.htmlbItem.getLinkReference() != null && this.htmlbItem.getLinkReference().length() > 0) {
            return this.htmlbItem.getLinkReference();
        }
        return "";
    }

    public String getLinkTarget() {
        if (this.htmlbItem.getLinkTarget() != null && this.htmlbItem.getLinkTarget().length() > 0) {
            return this.htmlbItem.getLinkTarget();
        }
        return "";
    }

    public boolean getHasIcon() {
        return this.htmlbItem.getImgSrc() != null && this.htmlbItem.getImgSrc().length() > 0;
    }

    public String getEnabledIconSrc() {
        if (this.htmlbItem.getImgSrc() != null && this.htmlbItem.getImgSrc().length() > 0) {
            return this.htmlbItem.getImgSrc();
        }
        return "";
    }

    public String getDisabledIconSrc() {
        if (this.htmlbItem.getDisabledImgSrc() != null && this.htmlbItem.getDisabledImgSrc().length() > 0) {
            return this.htmlbItem.getDisabledImgSrc();
        }
        if (this.htmlbItem.getImgSrc() != null && this.htmlbItem.getImgSrc().length() > 0) {
            return this.htmlbItem.getImgSrc();
        }
        return "";
    }

    public String getGroupId() {
        return "";
    }

    public Component getHtmlBControl() {
        return null;
    }

    public String getJSEventFunction(ClientEvent event) {
        return "";
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.POPUPMENUITEMSELECT) {
            if (this.htmlbItem.getClientSideScript() != null) {
                String clientSideScript = null;
                clientSideScript = "me.sapUrMapi_PopupMenu_hideAll();event.cancelBubble=true;";
                clientSideScript = clientSideScript + this.htmlbItem.getClientSideScript();
                if (this.htmlbItem.isCheckable()) {
                    clientSideScript = "me.htmlb_MnuItemToggleChecked('" + pc.getParamIdForComponent(this.htmlbItem.getParentMenu()) + "','" + this.index + "');" + clientSideScript + ";event.cancelBubble=true;";
                }
                return clientSideScript;
            }
            if (this.htmlbItem.getParentMenu().requiresForm()) {
                String serverEvent = HoverItemClickEvent.renderEventCall(pc, this.htmlbItem.getParentMenu(), this.htmlbItem);
                if (this.htmlbItem.isCheckable()) {
                    return "me.htmlb_MnuItemToggleChecked('" + pc.getParamIdForComponent(this.htmlbItem.getParentMenu()) + "','" + this.index + "');" + serverEvent;
                }
                return "me.sapUrMapi_PopupMenu_hideAll();" + serverEvent;
            }
            if (this.htmlbItem.isCheckable()) {
                return "me.htmlb_MnuItemToggleChecked('" + pc.getParamIdForComponent(this.htmlbItem.getParentMenu()) + "','" + this.index + "');";
            }
            return "";
        }
        if (event == ClientEvent.POPUPMENUITEMLINKCLICK) {
            return "me.sapUrMapi_PopupMenu_hideAll();me.sapUrMapi_PopupMenu_ExecuteLink('" + this.id + "');event.cancelBubble=true;";
        }
        if (this.htmlbItem.isCheckable()) {
            return "me.htmlb_MnuItemToggleChecked('" + pc.getParamIdForComponent(this.htmlbItem.getParentMenu()) + "','" + this.index + "');";
        }
        return "";
    }

    public ForcedTextDirection getTextDirection() {
        return UrUtil.matchAlignment(this.htmlbItem.getTextDirection());
    }
}

