/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.hovermenu.HoverMenuItem;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.IURCollection;
import com.sapportals.htmlb.unifiedrendering.URCollection;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IPopupMenu;
import com.sapportals.htmlb.unifiedrendering.controls.PopupMenuItem;
import java.util.Iterator;
import java.util.List;

public class PopupMenu
implements IUIElement,
IPopupMenu {
    private HoverMenu htmlbHoverMenu;
    private IPageContext pc;
    private List items;

    public PopupMenu(Component component, IPageContext pageContext) {
        if (component instanceof HoverMenu) {
            this.htmlbHoverMenu = (HoverMenu)component;
            this.pc = pageContext;
            this.items = new URCollection();
            int i = 1;
            String id = this.pc.getParamIdForComponent(this.htmlbHoverMenu);
            Iterator it = this.htmlbHoverMenu.getMenuItemsIterator();
            while (it.hasNext()) {
                HoverMenuItem hItem = (HoverMenuItem)it.next();
                String subMenuId = hItem.getSubMenu() != null ? this.pc.getParamIdForComponent(hItem.getSubMenu()) : "";
                String itemId = id + "_" + i;
                PopupMenuItem item = new PopupMenuItem(hItem, itemId, subMenuId, i - 1);
                this.items.add(item);
                ++i;
            }
        }
    }

    public String getId() {
        return this.pc.getParamIdForComponent(this.htmlbHoverMenu);
    }

    public IURCollection getItems() {
        return (IURCollection)((Object)this.items);
    }

    public boolean getFirstLevelVisible() {
        return this.htmlbHoverMenu.isFirstLevelVisible();
    }

    public PopupMenuItem getItem(String id) {
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            PopupMenuItem i = (PopupMenuItem)it.next();
            if (!i.getId().equals(id)) continue;
            return i;
        }
        return null;
    }

    public int getMaxVisibleItems() {
        return 1000;
    }

    public int getFirstVisibleItemIdx() {
        return 1;
    }

    public Component getHtmlBControl() {
        return this.htmlbHoverMenu;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc, String isUp, boolean cancel) {
        if (event == ClientEvent.POPUPMENUSCROLL) {
            return "me.sapUrMapi_PopupMenu_timeScroll(window, '" + this.getId() + "','" + isUp + "'," + cancel + ",event)";
        }
        pc.getLogLocation().debugT("PopupMenu getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.POPUPMENUITEMMOUSEOVER) {
            return "me.htmlb_MnuToggle(window,'" + this.getId() + "',true,event)";
        }
        if (event == ClientEvent.POPUPMENUENTERSTANDALONE) {
            return "me.sapUrMapi_PopupMenu_init('" + this.getId() + "',event);";
        }
        if (event == ClientEvent.POPUPMENULEAVESTANDALONE) {
            return "me.sapUrMapi_PopupMenu_exit('" + this.getId() + "',event);";
        }
        if (event == ClientEvent.POPUPMENUFOCUSSTANDALONE) {
            return "me.sapUrMapi_PopupMenu_init('" + this.getId() + "',event);";
        }
        if (event == ClientEvent.POPUPMENUBLURSTANDALONE) {
            return "me.sapUrMapi_PopupMenu_exit('" + this.getId() + "',event);";
        }
        if (event == ClientEvent.POPUPMENUKEYDOWN) {
            return "me.sapUrMapi_PopupMenu_keyDown(window,'" + this.getId() + "',event);";
        }
        if (event == ClientEvent.POPUPMENUCREATE) {
            return "sapUrMapi_PopupMenu_drawInit('" + this.getId() + "');";
        }
        pc.getLogLocation().debugT("PopupMenu getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }
}

