/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IMessageBar;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.MessageBarRulerDisplay;
import com.sapportals.htmlb.unifiedrendering.enum.MessageType;

public class MessageBar
extends UrControl
implements IUIElement,
IMessageBar {
    private com.sapportals.htmlb.MessageBar htmlbMessageBar;
    private IPageContext pc;

    public MessageBar(Component component, IPageContext pageContext) {
        if (component instanceof com.sapportals.htmlb.MessageBar) {
            this.htmlbMessageBar = (com.sapportals.htmlb.MessageBar)component;
            this.pc = pageContext;
        }
    }

    public String getId() {
        return this.pc.getParamIdForComponent(this.htmlbMessageBar);
    }

    public String getText() {
        if (this.htmlbMessageBar.getMessageText() != null) {
            if (this.htmlbMessageBar.isEncode()) {
                return RenderUtil.encodeForHtmlDisplay(this.htmlbMessageBar.getMessageText());
            }
            return this.htmlbMessageBar.getMessageText();
        }
        return "";
    }

    public MessageType getType() {
        if (this.htmlbMessageBar.getMessageType() != null) {
            if (this.htmlbMessageBar.getMessageType() == com.sapportals.htmlb.enum.MessageType.VALIDATION) {
                return MessageType.ERROR;
            }
            if (this.htmlbMessageBar.getMessageType() == com.sapportals.htmlb.enum.MessageType.ERROR) {
                return MessageType.ERROR;
            }
            if (this.htmlbMessageBar.getMessageType() == com.sapportals.htmlb.enum.MessageType.INFO) {
                return MessageType.OK;
            }
            if (this.htmlbMessageBar.getMessageType() == com.sapportals.htmlb.enum.MessageType.LOADING) {
                return MessageType.LOADING;
            }
            if (this.htmlbMessageBar.getMessageType() == com.sapportals.htmlb.enum.MessageType.NONE) {
                return MessageType.NONE;
            }
            if (this.htmlbMessageBar.getMessageType() == com.sapportals.htmlb.enum.MessageType.WARNING) {
                return MessageType.WARNING;
            }
            if (this.htmlbMessageBar.getMessageType() == com.sapportals.htmlb.enum.MessageType.STOP) {
                return MessageType.STOP;
            }
            if (this.htmlbMessageBar.getMessageType() == com.sapportals.htmlb.enum.MessageType.TEXT) {
                return MessageType.TEXT;
            }
            return MessageType.NONE;
        }
        return MessageType.NONE;
    }

    public MessageBarRulerDisplay getRulerDisplay() {
        return MessageBarRulerDisplay.BOTTOM;
    }

    public Component getHtmlBControl() {
        return this.htmlbMessageBar;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.MESSAGEBARCLICK) {
            return "";
        }
        pc.getLogLocation().debugT("MessageBar getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public String getConnectedControlId() {
        return "";
    }

    public String getTooltip() {
        if (this.htmlbMessageBar.isEncode()) {
            return RenderUtil.encodeForHtmlDisplay(this.htmlbMessageBar.getMessageText());
        }
        return RenderUtil.encodeForHtmlDisplay(UrUtil.eliminateTags(this.htmlbMessageBar.getMessageText()));
    }
}

