/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.MenuItem;
import com.sapportals.htmlb.enum.HoverMenuTrigger;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IMenuBarItem;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;

public class MenuBarItem
extends UrControl
implements IMenuBarItem {
    private MenuItem htmlbMenuBarItem;
    private IPageContext pc;
    private String menuBarId;
    private int currentIndex;

    public MenuBarItem(MenuItem component, IPageContext pageContext, String menuBarId, int currentIndex) {
        this.htmlbMenuBarItem = component;
        this.pc = pageContext;
        this.menuBarId = menuBarId;
        this.currentIndex = currentIndex;
    }

    public String getId() {
        return this.menuBarId + "_" + this.htmlbMenuBarItem.getId();
    }

    public boolean getEnabled() {
        return this.htmlbMenuBarItem.isEnabled();
    }

    public String getCaption() {
        if (this.htmlbMenuBarItem.getText() != null) {
            return RenderUtil.encodeForHtml(this.htmlbMenuBarItem.getText());
        }
        return "";
    }

    public String getTooltip() {
        return "";
    }

    public String getPopupMenuId() {
        return this.pc.getParamIdForComponent(this.htmlbMenuBarItem.getHoverMenu());
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.MENUBARITEMCLICK) {
            if (this.htmlbMenuBarItem.getMenuBar().getMenuTrigger() == HoverMenuTrigger.ONCLICK || this.htmlbMenuBarItem.getMenuBar().getMenuTrigger() == HoverMenuTrigger.ONLRCLICK || this.htmlbMenuBarItem.getMenuBar().getMenuTrigger() == null) {
                return "htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbMenuBarItem.getId() + "',event)";
            }
            return "";
        }
        if (event == ClientEvent.MENUBARITEMMOUSEOVER) {
            if (this.htmlbMenuBarItem.getMenuBar().getMenuTrigger() == HoverMenuTrigger.ONMOUSEOVER) {
                return "htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbMenuBarItem.getId() + "',event)";
            }
            return "sapUrMapi_MenuBar_hover('" + this.getId() + "',event)";
        }
        if (event == ClientEvent.MENUBARITEMRIGHTCLICK) {
            if (this.htmlbMenuBarItem.getMenuBar().getMenuTrigger() == HoverMenuTrigger.ONCONTEXTMENU || this.htmlbMenuBarItem.getMenuBar().getMenuTrigger() == HoverMenuTrigger.ONLRCLICK) {
                return "htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbMenuBarItem.getId() + "',event);return false;";
            }
            return "";
        }
        if (event == ClientEvent.MENUBARITEMMOUSEOUT) {
            return "sapUrMapi_MenuBar_hover('" + this.getId() + "',event)";
        }
        if (event == ClientEvent.MENUBARITEMKEYDOWN) {
            return "sapUrMapi_MenuBarItem_keyDown('" + this.getId() + "'," + this.currentIndex + ",event)";
        }
        pc.getLogLocation().debugT("MenuBarItem getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public ForcedTextDirection getTextDirection() {
        return UrUtil.matchAlignment(this.htmlbMenuBarItem.getTextDirection());
    }
}

