/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.MenuItem;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.IURCollection;
import com.sapportals.htmlb.unifiedrendering.URCollection;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IMenuBar;
import com.sapportals.htmlb.unifiedrendering.controls.MenuBarItem;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.MenuBarDesign;
import java.util.Iterator;
import java.util.List;

public class MenuBar
extends UrControl
implements IUIElement,
IMenuBar {
    private com.sapportals.htmlb.MenuBar htmlbMenuBar;
    private IPageContext pc;
    private List items = null;

    public MenuBar(Component component, IPageContext pageContext) {
        if (component instanceof com.sapportals.htmlb.MenuBar) {
            this.htmlbMenuBar = (com.sapportals.htmlb.MenuBar)component;
            this.pc = pageContext;
            this.items = new URCollection();
            Iterator it = this.htmlbMenuBar.getMenuItemsIterator();
            int indx = 0;
            if (it != null) {
                while (it.hasNext()) {
                    MenuItem menuItem = (MenuItem)it.next();
                    MenuBarItem item = new MenuBarItem(menuItem, this.pc, this.getId(), indx);
                    ++indx;
                    this.items.add(item);
                }
            }
        }
    }

    public String getId() {
        return this.pc.getParamIdForComponent(this.htmlbMenuBar);
    }

    public MenuBarDesign getDesign() {
        if (this.htmlbMenuBar.getDesign() != null && this.htmlbMenuBar.getDesign().equals(com.sapportals.htmlb.enum.MenuBarDesign.TRANSPARENT)) {
            return MenuBarDesign.TRANSPARENT;
        }
        return MenuBarDesign.STANDARD;
    }

    public String getWidth() {
        if (this.htmlbMenuBar.getWidth() != null) {
            return this.htmlbMenuBar.getWidth();
        }
        return "";
    }

    public IURCollection getItems() {
        return (IURCollection)((Object)this.items);
    }

    public MenuBarItem getItem(String id) {
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            MenuBarItem i = (MenuBarItem)it.next();
            if (!i.getId().equals(id)) continue;
            return i;
        }
        return null;
    }

    public Component getHtmlBControl() {
        return this.htmlbMenuBar;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.MENUBARKEYDOWN) {
            return "sapUrMapi_MenuBar_keyDown('" + this.getId() + "',event)";
        }
        pc.getLogLocation().debugT("MenuBar getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }
}

