/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.enum.HoverMenuTrigger;
import com.sapportals.htmlb.enum.LinkDesign;
import com.sapportals.htmlb.enum.LinkFontSize;
import com.sapportals.htmlb.hovermenu.LinkForHoverMenu;
import com.sapportals.htmlb.rendering.ComponentValidationRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ICaption;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ILink;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.LinkSize;
import com.sapportals.htmlb.unifiedrendering.enum.LinkType;

public class Link
extends UrControl
implements IUIElement,
ILink {
    private com.sapportals.htmlb.Link htmlbLink;
    private LinkForHoverMenu htmlbHoverMenuLink;
    private IPageContext pc;
    static /* synthetic */ Class class$com$sapportals$htmlb$event$ButtonClickEvent;

    public Link(Component component, IPageContext pageContext) {
        if (component instanceof com.sapportals.htmlb.Link) {
            this.htmlbLink = (com.sapportals.htmlb.Link)component;
            this.pc = pageContext;
        }
        if (component instanceof LinkForHoverMenu) {
            this.htmlbHoverMenuLink = (LinkForHoverMenu)component;
            this.pc = pageContext;
        }
    }

    public String getId() {
        if (this.htmlbLink != null) {
            return this.pc.getParamIdForComponent(this.htmlbLink);
        }
        return this.pc.getParamIdForComponent(this.htmlbHoverMenuLink);
    }

    public boolean getIsTextLink() {
        return this.htmlbHoverMenuLink != null;
    }

    public String getText() {
        if (this.htmlbHoverMenuLink != null && this.htmlbHoverMenuLink.getText() != null) {
            return RenderUtil.encodeForHtml(this.htmlbHoverMenuLink.getText());
        }
        if (this.pc.getIs508()) {
            if (this.htmlbLink.getInnerText() != null) {
                return RenderUtil.encodeForHtml(this.htmlbLink.getInnerText().getText());
            }
            return "";
        }
        return "";
    }

    public LinkSize getSize() {
        LinkFontSize fSize = this.htmlbLink != null ? this.htmlbLink.getFontSize() : this.htmlbHoverMenuLink.getFontSize();
        if (fSize == LinkFontSize.SMALL) {
            return LinkSize.SMALL;
        }
        return LinkSize.DEFAULT;
    }

    public String getTarget() {
        if (this.htmlbLink != null && this.htmlbLink.getTarget() != null) {
            return RenderUtil.encodeForHtml(this.htmlbLink.getTarget());
        }
        return "";
    }

    public String getTooltip() {
        if (this.htmlbLink != null && this.htmlbLink.getTooltip() != null) {
            return RenderUtil.encodeForHtml(this.htmlbLink.getTooltip());
        }
        if (this.htmlbHoverMenuLink != null && this.htmlbHoverMenuLink.getTooltip() != null) {
            return RenderUtil.encodeForHtml(this.htmlbHoverMenuLink.getTooltip());
        }
        return "";
    }

    public String getReference() {
        String reference = null;
        if (this.htmlbLink != null) {
            reference = this.htmlbLink.getReference();
        }
        if (this.htmlbLink != null && reference != null && !"".equals(reference)) {
            return Link.encodeQuotes(reference);
        }
        if (this.htmlbLink != null && this.htmlbLink.getOnClick() != null && !"".equals(this.htmlbLink.getOnClick())) {
            return "javascript:void()";
        }
        return "";
    }

    public IUIElement getContent() {
        if (this.htmlbLink != null) {
            return this;
        }
        return null;
    }

    public boolean getHasReference() {
        if (this.htmlbLink != null) {
            return this.htmlbLink.getReference() != null && this.htmlbLink.getReference() != "";
        }
        return false;
    }

    public LinkType getLinkType() {
        if (this.htmlbLink != null) {
            if (this.htmlbLink.getLinkDesign() == LinkDesign.DRILLDOWN) {
                return LinkType.DEFAULT;
            }
            if (this.htmlbLink.getLinkDesign() == LinkDesign.FUNCTION) {
                return LinkType.FUNCTION;
            }
            if (this.htmlbLink.getLinkDesign() == LinkDesign.REPORTING) {
                return LinkType.REPORTING;
            }
            if (this.htmlbLink.getLinkDesign() == LinkDesign.RESULT) {
                return LinkType.RESULT;
            }
            if (this.htmlbLink.getLinkDesign() == LinkDesign.DRAGRELATE) {
                return LinkType.DRAGRELATE;
            }
            return LinkType.DEFAULT;
        }
        if (this.htmlbHoverMenuLink != null) {
            if (this.htmlbHoverMenuLink.getLinkDesign() == LinkDesign.DRILLDOWN) {
                return LinkType.DEFAULT;
            }
            if (this.htmlbHoverMenuLink.getLinkDesign() == LinkDesign.FUNCTION) {
                return LinkType.FUNCTION;
            }
            if (this.htmlbHoverMenuLink.getLinkDesign() == LinkDesign.REPORTING) {
                return LinkType.REPORTING;
            }
            if (this.htmlbHoverMenuLink.getLinkDesign() == LinkDesign.RESULT) {
                return LinkType.RESULT;
            }
            if (this.htmlbHoverMenuLink.getLinkDesign() == LinkDesign.DRAGRELATE) {
                return LinkType.DRAGRELATE;
            }
            return LinkType.DEFAULT;
        }
        return LinkType.DEFAULT;
    }

    public boolean getEnabled() {
        if (this.htmlbLink != null) {
            return this.htmlbLink.getOnClick() != null && this.htmlbLink.getOnClick() != "" || this.htmlbLink.getReference() != null && this.htmlbLink.getReference() != "" || this.htmlbLink.getOnClientClick() != null && this.htmlbLink.getOnClientClick() != "";
        }
        return true;
    }

    public boolean getHasPopupMenu() {
        return this.htmlbHoverMenuLink != null && this.htmlbHoverMenuLink.getHoverMenu() != null;
    }

    public String getPopupMenuId() {
        if (this.htmlbHoverMenuLink != null && this.htmlbHoverMenuLink.getHoverMenu() != null) {
            if (this.htmlbHoverMenuLink.getHoverMenu().getId() != null) {
                return this.pc.getParamIdForComponent(this.htmlbHoverMenuLink.getHoverMenu());
            }
            return "";
        }
        return "";
    }

    public boolean getHasLinkCaption() {
        return false;
    }

    public ICaption getLinkCaption() {
        return null;
    }

    public boolean getWrapping() {
        if (this.htmlbHoverMenuLink != null) {
            return this.htmlbHoverMenuLink.isWrapping();
        }
        return true;
    }

    public boolean getIsNested() {
        return false;
    }

    public Component getHtmlBControl() {
        if (this.htmlbLink != null) {
            return this.htmlbLink;
        }
        return this.htmlbHoverMenuLink;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (this.htmlbLink != null) {
            if (event == ClientEvent.LINKCLICK) {
                if (this.htmlbLink.getOnClick() != null && this.htmlbLink.getOnClick().length() > 0 || this.htmlbLink.getOnClientClick() != null && this.htmlbLink.getOnClientClick().length() > 0) {
                    return ComponentValidationRenderer.renderEventValidationCall(class$com$sapportals$htmlb$event$ButtonClickEvent == null ? (class$com$sapportals$htmlb$event$ButtonClickEvent = Link.class$("com.sapportals.htmlb.event.ButtonClickEvent")) : class$com$sapportals$htmlb$event$ButtonClickEvent, true, true, this.htmlbLink, EventTrigger.ON_CLICK, pc);
                }
                if (this.htmlbLink.getReference() == null || this.htmlbLink.getReference() == "") return "";
                return "";
            }
            if (event == ClientEvent.LINKKEYDOWN) {
                if ((this.htmlbLink.getOnClick() == null || this.htmlbLink.getOnClick().length() <= 0) && (this.htmlbLink.getOnClientClick() == null || this.htmlbLink.getOnClientClick().length() <= 0)) return "";
                StringBuffer f = new StringBuffer();
                f.append("if (sapUrMapi_Link_activate('" + this.getId() + "',event)) { ");
                f.append(ComponentValidationRenderer.renderEventValidationCall(class$com$sapportals$htmlb$event$ButtonClickEvent == null ? (class$com$sapportals$htmlb$event$ButtonClickEvent = Link.class$("com.sapportals.htmlb.event.ButtonClickEvent")) : class$com$sapportals$htmlb$event$ButtonClickEvent, true, true, this.htmlbLink, EventTrigger.ON_CLICK, pc));
                f.append(" };");
                return f.toString();
            }
            pc.getLogLocation().debugT("Link getJsEventFunction: ", "Event " + event.toString() + " not handled");
            return "";
        }
        if (!this.getHasPopupMenu()) return "";
        if (event == ClientEvent.LINKCLICK) {
            if (this.htmlbHoverMenuLink.getHoverMenu().getMenuTrigger() != HoverMenuTrigger.ONCLICK && this.htmlbHoverMenuLink.getHoverMenu().getMenuTrigger() != HoverMenuTrigger.ONLRCLICK && this.htmlbHoverMenuLink.getHoverMenu().getMenuTrigger() != null) return "";
            return "htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbHoverMenuLink.getId() + "',event);return false;";
        }
        if (event == ClientEvent.LINKMOUSEOVER) {
            if (this.htmlbHoverMenuLink.getHoverMenu().getMenuTrigger() != HoverMenuTrigger.ONMOUSEOVER) return "";
            return "htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbHoverMenuLink.getId() + "',event);return false;";
        }
        if (event == ClientEvent.LINKRIGHTCLICK) {
            if (this.htmlbHoverMenuLink.getHoverMenu().getMenuTrigger() != HoverMenuTrigger.ONCONTEXTMENU && this.htmlbHoverMenuLink.getHoverMenu().getMenuTrigger() != HoverMenuTrigger.ONLRCLICK) return "";
            return "htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbHoverMenuLink.getId() + "',event);return false;";
        }
        if (event == ClientEvent.LINKKEYDOWN) {
            StringBuffer f = new StringBuffer();
            f.append("if (sapUrMapi_Link_activate('" + this.getId() + "',event)) { ");
            f.append("htmlb_ShowPopupMenu('" + this.getId() + "','" + this.getPopupMenuId() + "','" + this.htmlbHoverMenuLink.getId() + "',event);return false;");
            f.append(" };");
            return f.toString();
        }
        pc.getLogLocation().debugT("Link (hover) getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public String getMimeType() {
        return "";
    }

    public ForcedTextDirection getTextDirection() {
        if (this.htmlbLink != null) {
            return UrUtil.matchAlignment(this.htmlbLink.getTextDirection());
        }
        if (this.htmlbHoverMenuLink != null) {
            return UrUtil.matchAlignment(this.htmlbHoverMenuLink.getTextDirection());
        }
        return ForcedTextDirection.INHERIT;
    }

    public static String encodeQuotes(String text) {
        StringBuffer buff = new StringBuffer(text.length());
        char c = '\u0000';
        int i = 0;
        while (i < text.length()) {
            c = text.charAt(i);
            if (c == '\"') {
                buff.append("&quot;");
            } else {
                buff.append(c);
            }
            ++i;
        }
        return buff.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

