/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.TextViewDesign;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ILabel;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.LabelDesign;
import com.sapportals.htmlb.unifiedrendering.enum.LabelSize;

public class Label
extends UrControl
implements IUIElement,
ILabel {
    private com.sapportals.htmlb.Label htmlbLabel;
    private IPageContext pc;

    public Label(Component component, IPageContext pageContext) {
        if (component instanceof com.sapportals.htmlb.Label) {
            this.htmlbLabel = (com.sapportals.htmlb.Label)component;
            this.pc = pageContext;
        }
    }

    public String getId() {
        if (this.htmlbLabel.isJsObjectNeeded()) {
            return this.pc.getParamIdForComponent(this.htmlbLabel);
        }
        return "";
    }

    public String getTooltip() {
        if (this.htmlbLabel.getTooltip() != null) {
            return RenderUtil.encodeForHtml(this.htmlbLabel.getTooltip());
        }
        return "";
    }

    public String getLabelFor() {
        Component c = (Component)((Object)this.htmlbLabel.getLabelFor());
        if (c != null) {
            return this.pc.getParamIdForComponent(c);
        }
        String componentId = this.htmlbLabel.getLabeledComponentId();
        return this.pc.getComponentIdForLabel(componentId);
    }

    public boolean getWrapping() {
        return this.htmlbLabel.isWrapping();
    }

    public String getText() {
        if (this.htmlbLabel.getText() != null) {
            if (this.htmlbLabel.isEncode()) {
                return RenderUtil.encodeForHtml(this.htmlbLabel.getText());
            }
            return this.htmlbLabel.getText();
        }
        return "";
    }

    public boolean getInvalid() {
        return !this.htmlbLabel.isValid();
    }

    public boolean getRequired() {
        return this.htmlbLabel.isRequired();
    }

    public boolean getEnabled() {
        return this.htmlbLabel.isEnabled();
    }

    public LabelDesign getDesignBar() {
        if (this.htmlbLabel.hasDesignBar()) {
            return LabelDesign.STANDARD;
        }
        return LabelDesign.LIGHT;
    }

    public boolean getEncode() {
        return this.htmlbLabel.isEncode();
    }

    public LabelSize getSize() {
        if (this.htmlbLabel.getDesign() == TextViewDesign.LABELSMALL) {
            return LabelSize.SMALL;
        }
        return LabelSize.DEFAULT;
    }

    public boolean getHasIcon() {
        return false;
    }

    public String getIconSrc() {
        return "";
    }

    public String getWidth() {
        return "";
    }

    public Component getHtmlBControl() {
        return this.htmlbLabel;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.LABELFOCUS) {
            return "sapUrMapi_Label_FocusLabeledElement('" + this.getLabelFor() + "');";
        }
        if (event == ClientEvent.LABELCLICK) {
            return "sapUrMapi_Label_clickLabeledElement(null,'" + this.getLabelFor() + "',event);";
        }
        pc.getLogLocation().debugT("Label getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public String toString() {
        return this.getText();
    }

    public String getLabeledControlName() {
        String name = this.htmlbLabel.getLabledComponentClassName();
        if ((name = name.substring(name.lastIndexOf(46) + 1)).equals("DropdownListBox")) {
            name = "DropDownListBox";
        }
        return name;
    }

    public String getRequiredIndicatorTooltip() {
        return "";
    }

    public boolean getReadonly() {
        return false;
    }

    public ForcedTextDirection getTextDirection() {
        return UrUtil.matchAlignment(this.htmlbLabel.getTextDirection());
    }
}

