/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.ItemList;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.type.DataString;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IItemListItem;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;

public class ItemListItem
extends UrControl
implements IUIElement,
IItemListItem {
    private ItemList htmlbItemList;
    private Component component;
    private String text;
    private ForcedTextDirection textDirection;

    public ItemListItem(ItemList itemList, Component comp) {
        this.htmlbItemList = itemList;
        this.component = comp;
    }

    public ItemListItem(ItemList itemList, DataString dataString) {
        this.htmlbItemList = itemList;
        this.text = !dataString.isEncode() ? dataString.getValue() : dataString.getValue();
    }

    public ItemListItem(ItemList itemList, String string) {
        this.htmlbItemList = itemList;
        this.text = string;
    }

    public String getText() {
        if (this.component == null) {
            return RenderUtil.encodeForHtml(this.text);
        }
        return "";
    }

    public IUIElement getContent() {
        return this;
    }

    public boolean getIsControl() {
        return this.component != null;
    }

    public boolean getHasImageUrl() {
        return this.htmlbItemList.getBulletUri() != null || this.htmlbItemList.getComponentBulletUri(this.component) != null;
    }

    public String getImageUrl() {
        if (this.component != null && this.htmlbItemList.getComponentBulletUri(this.component) != null) {
            return this.htmlbItemList.getComponentBulletUri(this.component);
        }
        return this.htmlbItemList.getBulletUri();
    }

    public boolean getHasBulletStyle() {
        return this.component != null && this.htmlbItemList.getComponentStyle(this.component) != null;
    }

    public String getBulletStyle() {
        if (this.component != null && this.htmlbItemList.getComponentStyle(this.component) != null) {
            return this.htmlbItemList.getComponentStyle(this.component);
        }
        return "";
    }

    public Component getHtmlBControl() {
        return this.component;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        pc.getLogLocation().debugT("ItemListItem getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection getTextDirection() {
        return UrUtil.matchAlignment(this.textDirection);
    }
}

