/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Label;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.enum.InputFieldDesign;
import com.sapportals.htmlb.rendering.ComponentValidationRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataBCD;
import com.sapportals.htmlb.type.DataBoolean;
import com.sapportals.htmlb.type.DataDate;
import com.sapportals.htmlb.type.DataInteger;
import com.sapportals.htmlb.type.DataString;
import com.sapportals.htmlb.type.DataTime;
import com.sapportals.htmlb.type.TypeFormatter;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IInputField;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.ForcedTextDirection;
import com.sapportals.htmlb.unifiedrendering.enum.HorizontalAlign;
import com.sapportals.htmlb.unifiedrendering.enum.InputFieldFieldHelp;
import com.sapportals.htmlb.unifiedrendering.enum.InputFieldSize;
import com.sapportals.htmlb.unifiedrendering.enum.InputFieldType;
import com.sapportals.htmlb.valuehelp.ValueHelpContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

public class InputField
extends UrControl
implements IUIElement,
IInputField {
    private com.sapportals.htmlb.InputField htmlbInputField;
    private IPageContext pc;
    static /* synthetic */ Class class$com$sapportals$htmlb$event$Event;

    public InputField(Component component, IPageContext pageContext) {
        if (component instanceof com.sapportals.htmlb.InputField) {
            this.htmlbInputField = (com.sapportals.htmlb.InputField)component;
            this.pc = pageContext;
        }
    }

    public String getId() {
        return this.pc.getParamIdForComponent(this.htmlbInputField);
    }

    public String getName() {
        return this.pc.getParamIdForComponent(this.htmlbInputField);
    }

    public String getTooltip() {
        if (this.htmlbInputField.getTooltip() != null) {
            return RenderUtil.encodeForHtml(this.htmlbInputField.getTooltip());
        }
        return "";
    }

    public String getValue() {
        Object value = this.htmlbInputField.getValue();
        String valueString = "";
        if (value != null) {
            if (value instanceof AbstractDataType) {
                AbstractDataType dataValue = (AbstractDataType)value;
                if (dataValue != null) {
                    if (dataValue.isValid()) {
                        if (this.htmlbInputField.getValueEncode()) {
                            return RenderUtil.encodeForHtml(dataValue.toString(this.pc));
                        }
                        return dataValue.toString(this.pc);
                    }
                    if (dataValue instanceof DataString) {
                        if (this.htmlbInputField.getValueEncode()) {
                            return RenderUtil.encodeForHtml(dataValue.toString(this.pc));
                        }
                        return dataValue.toString(this.pc);
                    }
                    if (this.htmlbInputField.getValueEncode()) {
                        return RenderUtil.encodeForHtml(dataValue.getValueAsString());
                    }
                    return dataValue.getValueAsString();
                }
            } else {
                if (this.htmlbInputField.getValueEncode()) {
                    return RenderUtil.encodeForHtml(value.toString());
                }
                return value.toString();
            }
            if (this.htmlbInputField.getValueEncode()) {
                return RenderUtil.encodeForHtml(valueString);
            }
            return valueString;
        }
        return "";
    }

    public int getLength() {
        return this.htmlbInputField.getSize();
    }

    public int getMaxLength() {
        return this.htmlbInputField.getMaxlength();
    }

    public String getWidth() {
        if (this.htmlbInputField.getWidth() != null) {
            return this.htmlbInputField.getWidth();
        }
        return "";
    }

    public boolean getInvalid() {
        return !this.htmlbInputField.isValid();
    }

    public boolean getRequired() {
        if (this.htmlbInputField.isEnabled()) {
            return this.htmlbInputField.isRequired();
        }
        return false;
    }

    public boolean getEnabled() {
        return true;
    }

    public boolean getReadonly() {
        return !this.htmlbInputField.isEnabled();
    }

    public boolean getShowHelp() {
        return this.htmlbInputField.isShowHelp() && this.htmlbInputField.getType().equals(DataType.DATE) || this.htmlbInputField.isShowValueHelp();
    }

    public boolean getPasswordField() {
        return this.htmlbInputField.isPassword();
    }

    public InputFieldSize getSize() {
        if (this.htmlbInputField.getDesign() == InputFieldDesign.SMALL) {
            return InputFieldSize.SMALL;
        }
        return InputFieldSize.DEFAULT;
    }

    public InputFieldType getType() {
        Object value = this.htmlbInputField.getValue();
        if (value instanceof AbstractDataType) {
            if (value instanceof DataString) {
                return InputFieldType.STRING;
            }
            if (value instanceof DataBoolean) {
                return InputFieldType.BOOLEAN;
            }
            if (value instanceof DataTime) {
                return InputFieldType.TIME;
            }
            if (value instanceof DataDate) {
                return InputFieldType.DATE;
            }
            if (value instanceof DataBCD) {
                return InputFieldType.BDC;
            }
            if (value instanceof DataInteger) {
                return InputFieldType.INTEGER;
            }
            return InputFieldType.STRING;
        }
        return InputFieldType.STRING;
    }

    public boolean getHidden() {
        return !this.htmlbInputField.isVisible();
    }

    public InputFieldFieldHelp getFieldHelp() {
        if (this.htmlbInputField.getType() == DataType.DATE) {
            return InputFieldFieldHelp.CALENDAR;
        }
        if (this.htmlbInputField.isShowValueHelp()) {
            return InputFieldFieldHelp.F4LOOKUP;
        }
        return InputFieldFieldHelp.DEFAULT;
    }

    public HorizontalAlign getAlign() {
        return UrUtil.matchAlignment(this.htmlbInputField.getHAlign());
    }

    public Component getHtmlBControl() {
        return this.htmlbInputField;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.INPUTFIELDFIELDHELPCLICK) {
            StringBuffer eventString = new StringBuffer();
            if (this.getFieldHelp() == InputFieldFieldHelp.F4LOOKUP) {
                ValueHelpContext context = this.htmlbInputField.getValueHelpContext();
                if (context != null) {
                    eventString.append("htmlb_showValueHelp(event, '");
                    eventString.append(this.getId());
                    eventString.append("','");
                    eventString.append(context.getTargetApplication());
                    eventString.append("',");
                    eventString.append(context.getWidth());
                    eventString.append(",");
                    eventString.append(context.getHeight());
                    if (context.isResizable()) {
                        eventString.append(",true");
                    } else {
                        eventString.append(",false");
                    }
                    if (context.getDataTransferComponent() != null) {
                        eventString.append(",true");
                    } else {
                        eventString.append(",false");
                    }
                    String submitButtonId = context.getSubmitButtonId();
                    if (submitButtonId != null && !submitButtonId.equals("")) {
                        eventString.append(",'");
                        eventString.append(submitButtonId);
                        eventString.append("'");
                    }
                    eventString.append(")");
                }
            } else {
                eventString.append("htmlb_showDateHelp(event,'");
                eventString.append(this.getId());
                eventString.append("','");
                SimpleDateFormat sdf = (SimpleDateFormat)TypeFormatter.getFormat(pc.getLocale(), DataType.DATE);
                String pattern = sdf.toPattern();
                eventString.append(pattern);
                eventString.append("','");
                Calendar cal = Calendar.getInstance(pc.getLocale());
                eventString.append(cal.getFirstDayOfWeek());
                eventString.append("')");
            }
            return eventString.toString();
        }
        if (this.htmlbInputField.isEnabled()) {
            boolean validateControl = false;
            ArrayList validators = this.htmlbInputField.getAllValidators();
            if (validators != null && !validators.isEmpty()) {
                validateControl = true;
            }
            if (event == ClientEvent.INPUTFIELDBLUR) {
                return ComponentValidationRenderer.renderEventValidationCall(class$com$sapportals$htmlb$event$Event == null ? (class$com$sapportals$htmlb$event$Event = InputField.class$("com.sapportals.htmlb.event.Event")) : class$com$sapportals$htmlb$event$Event, validateControl, false, this.htmlbInputField, EventTrigger.ON_BLUR, pc);
            }
            if (event == ClientEvent.INPUTFIELDCHANGE) {
                return ComponentValidationRenderer.renderEventValidationCall(class$com$sapportals$htmlb$event$Event == null ? (class$com$sapportals$htmlb$event$Event = InputField.class$("com.sapportals.htmlb.event.Event")) : class$com$sapportals$htmlb$event$Event, validateControl, false, this.htmlbInputField, EventTrigger.ON_CHANGE, pc);
            }
            if (event == ClientEvent.INPUTFIELDKEYPRESS) {
                if (this.htmlbInputField.getClientEvent(EventTrigger.ON_KEYPRESS) != null) {
                    return ComponentValidationRenderer.renderEventValidationCall(class$com$sapportals$htmlb$event$Event == null ? (class$com$sapportals$htmlb$event$Event = InputField.class$("com.sapportals.htmlb.event.Event")) : class$com$sapportals$htmlb$event$Event, false, false, this.htmlbInputField, EventTrigger.ON_KEYPRESS, pc);
                }
                return "";
            }
            if (event == ClientEvent.INPUTFIELDFOCUS) {
                if (this.htmlbInputField.getClientEvent(EventTrigger.ON_FOCUS) != null) {
                    return "sapUrMapi_InputField_focus('" + this.getId() + "',event);" + ComponentValidationRenderer.renderEventValidationCall(class$com$sapportals$htmlb$event$Event == null ? (class$com$sapportals$htmlb$event$Event = InputField.class$("com.sapportals.htmlb.event.Event")) : class$com$sapportals$htmlb$event$Event, false, false, this.htmlbInputField, EventTrigger.ON_FOCUS, pc);
                }
                return "sapUrMapi_InputField_focus('" + this.getId() + "',event);";
            }
            if (event == ClientEvent.INPUTFIELDKEYDOWN) {
                if (this.htmlbInputField.getClientEvent(EventTrigger.ON_KEYDOWN) != null) {
                    return "sapUrMapi_InputField_keydown('" + this.getId() + "',event);" + ComponentValidationRenderer.renderEventValidationCall(class$com$sapportals$htmlb$event$Event == null ? (class$com$sapportals$htmlb$event$Event = InputField.class$("com.sapportals.htmlb.event.Event")) : class$com$sapportals$htmlb$event$Event, false, false, this.htmlbInputField, EventTrigger.ON_KEYDOWN, pc);
                }
                return "sapUrMapi_InputField_keydown('" + this.getId() + "',event);";
            }
            if (event == ClientEvent.INPUTFIELDKEYUP) {
                if (this.htmlbInputField.getClientEvent(EventTrigger.ON_KEYUP) != null) {
                    return ComponentValidationRenderer.renderEventValidationCall(class$com$sapportals$htmlb$event$Event == null ? (class$com$sapportals$htmlb$event$Event = InputField.class$("com.sapportals.htmlb.event.Event")) : class$com$sapportals$htmlb$event$Event, false, false, this.htmlbInputField, EventTrigger.ON_KEYUP, pc);
                }
                return "";
            }
            pc.getLogLocation().debugT("InputField getJsEventFunction: ", "Event " + event.toString() + " not handled");
            return "";
        }
        return "";
    }

    public String getLabelText() {
        Component c = this.htmlbInputField.getLabel();
        if (c instanceof Label) {
            Label l = (Label)c;
            return l.getText();
        }
        return "";
    }

    public boolean getShowInputLength() {
        return false;
    }

    public boolean getHideFieldHelp() {
        return !this.getEnabled();
    }

    public ForcedTextDirection getTextDirection() {
        return UrUtil.matchAlignment(this.htmlbInputField.getTextDirection());
    }

    public boolean getContainerWidthSet() {
        return false;
    }

    public boolean getUsedInSapTable() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

