/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.BrowserType;
import com.sapportals.htmlb.htmlcontainer.IsolatedHtmlContainer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IIframe;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.IframeScrolling;

public class Iframe
extends UrControl
implements IUIElement,
IIframe {
    private IsolatedHtmlContainer iFrame;
    private IPageContext pc;

    public Iframe(Component component, IPageContext pageContext) {
        if (component instanceof IsolatedHtmlContainer) {
            this.iFrame = (IsolatedHtmlContainer)component;
            this.pc = pageContext;
        }
    }

    public String getId() {
        return "";
    }

    public String getWidth() {
        if (this.iFrame.getWidth() != null) {
            return RenderUtil.encodeForHtmlDisplay(this.iFrame.getWidth());
        }
        return "";
    }

    public String getHeight() {
        if (this.iFrame.getHeight() != null) {
            if ((this.pc.getBrowserId() == BrowserType.NETSCAPE_4 || this.pc.getBrowserId() == BrowserType.NETSCAPE_6 || this.pc.getBrowserId() == BrowserType.NETSCAPE_7 || this.pc.getBrowserId() == BrowserType.MAC_NETSCAPE_4 || this.pc.getBrowserId() == BrowserType.MAC_NETSCAPE_6) && this.iFrame.getHeight().indexOf("%") >= 0) {
                return "";
            }
            return RenderUtil.encodeForHtmlDisplay(this.iFrame.getHeight());
        }
        return "";
    }

    public String getUrl() {
        if (this.iFrame.getSrcUrl() != null) {
            return RenderUtil.encodeForHtmlDisplay(this.iFrame.getSrcUrl());
        }
        return "";
    }

    public boolean getHasBorder() {
        return this.iFrame.isBordered();
    }

    public IframeScrolling getScrolling() {
        if (this.iFrame.getScrolling() != null) {
            return IframeScrolling.valueOf(this.iFrame.getScrolling().toString());
        }
        return IframeScrolling.NO;
    }

    public String getTooltip() {
        if (this.iFrame.getTooltip() != null) {
            return RenderUtil.encodeForHtml(this.iFrame.getTooltip());
        }
        return "";
    }

    public Component getHtmlBControl() {
        return this.iFrame;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        pc.getLogLocation().debugT("Iframe getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public String getName() {
        return "";
    }
}

