/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.GridCellBackgroundDesign;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.UrUtil;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IGridLayoutCell;
import com.sapportals.htmlb.unifiedrendering.enum.CellBackgroundDesign;
import com.sapportals.htmlb.unifiedrendering.enum.CellHAlign;
import com.sapportals.htmlb.unifiedrendering.enum.CellVAlign;

public class GridLayoutCell
implements IUIElement,
IGridLayoutCell {
    private com.sapportals.htmlb.GridLayoutCell htmlbGridCell;
    private int cellPadding;
    private int cellSpacing;
    private int row;
    private int col;

    public GridLayoutCell(com.sapportals.htmlb.GridLayoutCell htmlbGridCell, int padding, int spacing, int row, int col) {
        this.htmlbGridCell = htmlbGridCell;
        this.row = row;
        this.col = col;
        this.cellPadding = padding;
        this.cellSpacing = spacing;
    }

    public int getColSpan() {
        if (this.htmlbGridCell != null && this.htmlbGridCell.getColSpan() > 1) {
            return this.htmlbGridCell.getColSpan();
        }
        return 1;
    }

    public int getRowSpan() {
        return 1;
    }

    public CellHAlign getHAlign() {
        if (this.htmlbGridCell != null && this.htmlbGridCell.getHAlignment() != null) {
            return UrUtil.matchAlignment(this.htmlbGridCell.getHAlignment());
        }
        return CellHAlign.LEFT;
    }

    public CellVAlign getVAlign() {
        if (this.htmlbGridCell != null && this.htmlbGridCell.getVAlignment() != null) {
            return CellVAlign.valueOf(this.htmlbGridCell.getVAlignment().toString());
        }
        return CellVAlign.MIDDLE;
    }

    public String getWidth() {
        if (this.htmlbGridCell != null && this.htmlbGridCell.getWidth() != null) {
            return this.htmlbGridCell.getWidth();
        }
        return "";
    }

    public String getHeight() {
        if (this.htmlbGridCell != null && this.htmlbGridCell.getHeight() != null) {
            return this.htmlbGridCell.getHeight();
        }
        return "";
    }

    public String getPaddingTop() {
        return "0px";
    }

    public String getPaddingBottom() {
        return "0px";
    }

    public String getPaddingRight() {
        return "0px";
    }

    public String getPaddingLeft() {
        return "0px";
    }

    public IUIElement getContent() {
        if (this.htmlbGridCell != null) {
            return this;
        }
        return null;
    }

    public String getStyleClass() {
        if (this.htmlbGridCell != null && this.htmlbGridCell.getStyle() != null) {
            return this.htmlbGridCell.getStyle();
        }
        return "";
    }

    public String getId() {
        return "";
    }

    public boolean getWrapping() {
        return true;
    }

    public CellBackgroundDesign getCellBackgroundDesign() {
        if (this.htmlbGridCell != null && this.htmlbGridCell.getCellBackgroundDesign() != null) {
            if (this.htmlbGridCell.getCellBackgroundDesign() == GridCellBackgroundDesign.PLAIN) {
                return CellBackgroundDesign.PLAIN;
            }
            if (this.htmlbGridCell.getCellBackgroundDesign() == GridCellBackgroundDesign.BORDER) {
                return CellBackgroundDesign.BORDER;
            }
            if (this.htmlbGridCell.getCellBackgroundDesign() == GridCellBackgroundDesign.FILL1) {
                return CellBackgroundDesign.FILL1;
            }
            if (this.htmlbGridCell.getCellBackgroundDesign() == GridCellBackgroundDesign.FILL2) {
                return CellBackgroundDesign.FILL2;
            }
            if (this.htmlbGridCell.getCellBackgroundDesign() == GridCellBackgroundDesign.FILL3) {
                return CellBackgroundDesign.FILL3;
            }
            if (this.htmlbGridCell.getCellBackgroundDesign() == GridCellBackgroundDesign.HEADER) {
                return CellBackgroundDesign.HEADER;
            }
            return CellBackgroundDesign.TRANSPARENT;
        }
        return CellBackgroundDesign.TRANSPARENT;
    }

    public Component getHtmlBControl() {
        return this.htmlbGridCell;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        pc.getLogLocation().debugT("GridLayoutCell getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }
}

