/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.FormLayout;
import com.sapportals.htmlb.FormLayoutRow;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.IURCollection;
import com.sapportals.htmlb.unifiedrendering.URCollection;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IGridLayout;
import com.sapportals.htmlb.unifiedrendering.controls.GridLayoutRow;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.CellBackgroundDesign;
import java.util.List;

public class GridLayout
extends UrControl
implements IUIElement,
IGridLayout {
    private com.sapportals.htmlb.GridLayout htmlbGrid;
    private FormLayout htmlbFormLayout;
    private IPageContext pc;
    private List gridLayoutRows;
    private List formLayoutRows;
    boolean isFormLayout;
    private static boolean debug = System.getProperty("htmlb.debug") != null;

    public GridLayout(Component component, IPageContext pageContext) {
        block3: {
            block2: {
                if (!(component instanceof com.sapportals.htmlb.GridLayout)) break block2;
                this.isFormLayout = false;
                this.htmlbGrid = (com.sapportals.htmlb.GridLayout)component;
                this.pc = pageContext;
                Object[][] cells = this.htmlbGrid.getCells();
                this.gridLayoutRows = new URCollection();
                int i = 1;
                while (i < cells.length) {
                    GridLayoutRow row = new GridLayoutRow(this.htmlbGrid, i, cells[i]);
                    this.gridLayoutRows.add(row);
                    ++i;
                }
                break block3;
            }
            if (!(component instanceof FormLayout)) break block3;
            this.isFormLayout = true;
            this.htmlbFormLayout = (FormLayout)component;
            this.pc = pageContext;
            this.formLayoutRows = new URCollection();
            Object[] rows = this.htmlbFormLayout.getRows();
            int rowIndex = 0;
            while (rowIndex < rows.length) {
                com.sapportals.htmlb.unifiedrendering.controls.FormLayoutRow row = new com.sapportals.htmlb.unifiedrendering.controls.FormLayoutRow((FormLayoutRow)rows[rowIndex]);
                this.formLayoutRows.add(row);
                ++rowIndex;
            }
        }
    }

    public String getId() {
        return "";
    }

    public IURCollection getRows() {
        if (this.isFormLayout) {
            return (IURCollection)((Object)this.formLayoutRows);
        }
        return (IURCollection)((Object)this.gridLayoutRows);
    }

    public int getDefaultCellSpacing() {
        if (this.isFormLayout) {
            return 0;
        }
        return this.htmlbGrid.getCellSpacing();
    }

    public int getDefaultCellPadding() {
        if (this.isFormLayout) {
            return 0;
        }
        return this.htmlbGrid.getCellPadding();
    }

    public String getMarginTop() {
        if (this.isFormLayout) {
            if (this.htmlbFormLayout.getMarginTop() != null) {
                return this.htmlbFormLayout.getMarginTop();
            }
            return "";
        }
        return "";
    }

    public String getMarginBottom() {
        if (this.isFormLayout) {
            if (this.htmlbFormLayout.getMarginBottom() != null) {
                return this.htmlbFormLayout.getMarginBottom();
            }
            return "";
        }
        return "";
    }

    public String getMarginLeft() {
        if (this.isFormLayout) {
            if (this.htmlbFormLayout.getMarginLeft() != null) {
                return this.htmlbFormLayout.getMarginLeft();
            }
            return "";
        }
        return "";
    }

    public String getMarginRight() {
        if (this.isFormLayout) {
            if (this.htmlbFormLayout.getMarginRight() != null) {
                return this.htmlbFormLayout.getMarginRight();
            }
            return "";
        }
        return "";
    }

    public String getWidth() {
        if (this.isFormLayout) {
            if (this.htmlbFormLayout.getWidth() != null) {
                return this.htmlbFormLayout.getWidth();
            }
            return "";
        }
        if (this.htmlbGrid.getWidth() != null) {
            return this.htmlbGrid.getWidth();
        }
        return "";
    }

    public boolean getDebugMode() {
        if (!debug) {
            if (this.isFormLayout) {
                return this.htmlbFormLayout.isDebugMode();
            }
            return this.htmlbGrid.hasDebugMode();
        }
        return true;
    }

    public CellBackgroundDesign getCellBackgroundDesign() {
        return CellBackgroundDesign.TRANSPARENT;
    }

    public Component getHtmlBControl() {
        if (this.isFormLayout) {
            return this.htmlbFormLayout;
        }
        return this.htmlbGrid;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        pc.getLogLocation().debugT("GridLayout getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public String getHeight() {
        if (!this.isFormLayout) {
            if (this.htmlbGrid.getHeight() != null) {
                return this.htmlbGrid.getHeight();
            }
            return "";
        }
        return "";
    }

    public boolean getFixedLayout() {
        if (this.isFormLayout) {
            return false;
        }
        return this.htmlbGrid.isFixedLayout();
    }
}

