/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.event.DateNavigatorDayClickEvent;
import com.sapportals.htmlb.event.DateNavigatorMonthClickEvent;
import com.sapportals.htmlb.event.DateNavigatorNavigationEvent;
import com.sapportals.htmlb.event.DateNavigatorWeekClickEvent;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.IURCollection;
import com.sapportals.htmlb.unifiedrendering.URCollection;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IDateNavigator;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IDateNavigatorDay;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IDateNavigatorMonth;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IDateNavigatorRow;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IDateNavigatorWeek;
import com.sapportals.htmlb.unifiedrendering.controlinterface.ILegend;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.DateNavigatorDayDesign;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateNavigator
extends UrControl
implements IUIElement,
IDateNavigator {
    private com.sapportals.htmlb.DateNavigator htmlbDateNavigator;
    private IPageContext pc;
    private URCollection rowCollection = null;

    public DateNavigator(Component component, IPageContext pc) {
        if (component instanceof com.sapportals.htmlb.DateNavigator) {
            this.htmlbDateNavigator = (com.sapportals.htmlb.DateNavigator)component;
            this.pc = pc;
            this.rowCollection = new URCollection();
            this.buildModel();
        }
    }

    public String getId() {
        return this.pc.getParamIdForComponent(this.htmlbDateNavigator);
    }

    public IURCollection getRows() {
        return this.rowCollection;
    }

    public boolean getCanNavigate() {
        return true;
    }

    public boolean getHasLegend() {
        return false;
    }

    public ILegend getLegend() {
        return null;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event.equals(ClientEvent.DATENAVIGATORDAYCLICK)) {
            if (this.htmlbDateNavigator.getOnDayClick() == null || this.htmlbDateNavigator.getOnDayClick().length() < 1) {
                return "";
            }
            return DateNavigatorDayClickEvent.renderJSFunction(pc, this.htmlbDateNavigator);
        }
        if (event.equals(ClientEvent.DATENAVIGATORMOUSEMOVE)) {
            return "sapUrMapi_DateNavigator_mousemove('" + this.getId() + "',event)";
        }
        if (event.equals(ClientEvent.DATENAVIGATORKEYDOWN)) {
            return "sapUrMapi_DateNavigator_keydown('" + this.getId() + "',event)";
        }
        if (event.equals(ClientEvent.DATENAVIGATORACTIVATE)) {
            return "sapUrMapi_DateNavigator_activate('" + this.getId() + "',event)";
        }
        pc.getLogLocation().debugT("DateNavigator getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc, boolean up) {
        if (event.equals(ClientEvent.DATENAVIGATORNAVIGATE)) {
            if (this.htmlbDateNavigator.getOnNavigate() == null || this.htmlbDateNavigator.getOnNavigate().length() < 1) {
                return "";
            }
            if (!up) {
                return DateNavigatorNavigationEvent.renderEventCall(pc, this.htmlbDateNavigator, "previous");
            }
            return DateNavigatorNavigationEvent.renderEventCall(pc, this.htmlbDateNavigator, "next");
        }
        pc.getLogLocation().debugT("DateNavigator getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc, int mw, int year) {
        if (event.equals(ClientEvent.DATENAVIGATORWEEKCLICK)) {
            if (this.htmlbDateNavigator.getOnWeekClick() == null || this.htmlbDateNavigator.getOnWeekClick().length() < 1) {
                return "";
            }
            return DateNavigatorWeekClickEvent.renderEventCall(pc, this.htmlbDateNavigator, year, mw);
        }
        if (event.equals(ClientEvent.DATENAVIGATORMONTHCLICK)) {
            if (this.htmlbDateNavigator.getOnMonthClick() == null || this.htmlbDateNavigator.getOnMonthClick().length() < 1) {
                return "";
            }
            return DateNavigatorMonthClickEvent.renderEventCall(pc, this.htmlbDateNavigator, year, mw);
        }
        pc.getLogLocation().debugT("DateNavigator getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public Component getHtmlBControl() {
        return this.htmlbDateNavigator;
    }

    private void buildModel() {
        Calendar calendar = this.htmlbDateNavigator.getCalendar();
        calendar.setTime(this.htmlbDateNavigator.getToday());
        int year = this.htmlbDateNavigator.getCenteredYear() == null ? calendar.get(1) : this.htmlbDateNavigator.getCenteredYear().intValue();
        int month = this.htmlbDateNavigator.getCenteredMonth() == null ? calendar.get(2) : this.htmlbDateNavigator.getCenteredMonth().intValue();
        int rows = this.htmlbDateNavigator.getMonthsPerColumn();
        int cols = this.htmlbDateNavigator.getMonthsPerRow();
        int monthCount = rows * cols;
        int monthAmplidue = (monthCount + 1) / 2 - 1;
        calendar.set(year, month, 1);
        calendar.add(2, -monthAmplidue);
        int currYear = calendar.get(1);
        int currMonth = calendar.get(2);
        URCollection months = null;
        URCollection weeks = null;
        URCollection days = null;
        int firstDayOfWeek = 0;
        firstDayOfWeek = calendar.getFirstDayOfWeek();
        int i = 0;
        while (i < rows) {
            calendar.set(currYear, currMonth, 1, 0, 0, 0);
            calendar.set(14, 0);
            months = new URCollection();
            DateNavigatorMonth monthObject = null;
            int j = 0;
            while (j < cols) {
                monthObject = null;
                int firstDayOfMonth = calendar.get(7);
                SimpleDateFormat formatterMonth = new SimpleDateFormat("MMMMM", this.htmlbDateNavigator.getLocale());
                String monthName = formatterMonth.format(calendar.getTime());
                int renderedMonth = calendar.get(2);
                calendar.add(2, 1);
                int nextMonth = calendar.get(2);
                calendar.add(2, -1);
                int preDays = firstDayOfMonth - firstDayOfWeek;
                if (preDays < 0) {
                    preDays += 7;
                }
                calendar.add(5, -preDays);
                Date startDate = calendar.getTime();
                Date curDate = new Date(startDate.getTime());
                int curWeek = calendar.get(3);
                int curMonth = calendar.get(2);
                int curYear = calendar.get(1);
                calendar.setTime(startDate);
                weeks = new URCollection();
                DateNavigatorWeek week = null;
                int lines = 0;
                while (lines < 6) {
                    curMonth = calendar.get(2);
                    calendar.add(5, 6);
                    curWeek = calendar.get(3);
                    calendar.add(5, -6);
                    curYear = calendar.get(1);
                    days = new URCollection();
                    DateNavigatorDay dayObject = null;
                    DateNavigatorDayDesign dayDesign = null;
                    int selectionMode = -1;
                    int k = 0;
                    while (k < 7) {
                        int day = calendar.get(5);
                        curYear = calendar.get(1);
                        String dayID = DateNavigator.formatDayId(curYear, curMonth, day);
                        dayDesign = DateNavigatorDayDesign.NONE;
                        selectionMode = -1;
                        String dayTooltip = null;
                        boolean today = false;
                        if (this.htmlbDateNavigator.getSelectedDays() != null) {
                            dayTooltip = this.htmlbDateNavigator.getSelectedDays().getTooltip(calendar.getTime());
                            selectionMode = this.htmlbDateNavigator.getSelectedDays().getSelectionMode(calendar.getTime());
                        }
                        if (selectionMode != -1) {
                            switch (selectionMode) {
                                case 1: {
                                    dayDesign = DateNavigatorDayDesign.SELECTED1;
                                    break;
                                }
                                case 2: {
                                    dayDesign = DateNavigatorDayDesign.SELECTED2;
                                    break;
                                }
                                case 3: {
                                    dayDesign = DateNavigatorDayDesign.SELECTED3;
                                    break;
                                }
                                case 4: {
                                    dayDesign = DateNavigatorDayDesign.SELECTED4;
                                    break;
                                }
                                case 0: {
                                    dayDesign = DateNavigatorDayDesign.SELECTED5;
                                }
                            }
                        }
                        if (calendar.getTime().equals(this.htmlbDateNavigator.getToday())) {
                            dayDesign = DateNavigatorDayDesign.TODAY;
                            today = true;
                        } else {
                            today = false;
                        }
                        if (curMonth != renderedMonth) {
                            dayDesign = DateNavigatorDayDesign.DISABLED;
                        }
                        dayObject = new DateNavigatorDay(dayID, day, dayDesign, dayID, dayTooltip, renderedMonth, curYear, today);
                        days.add(dayObject);
                        calendar.add(5, 1);
                        curMonth = calendar.get(2);
                        ++k;
                    }
                    week = new DateNavigatorWeek(this.getId(), days, curWeek, curYear);
                    weeks.add(week);
                    ++lines;
                }
                monthObject = new DateNavigatorMonth("", weeks, monthName, currMonth, currYear, firstDayOfWeek - 1);
                months.add(monthObject);
                calendar.set(currYear, currMonth, 1);
                calendar.add(2, 1);
                currYear = calendar.get(1);
                currMonth = calendar.get(2);
                ++j;
            }
            this.rowCollection.add(new DateNavigatorRow(this.getId(), months));
            ++i;
        }
    }

    public static String formatDayId(int year, int month, int day) {
        int m2 = month + 1;
        StringBuffer result = new StringBuffer(8);
        if (year < 1000) {
            result.append('0');
        }
        if (year < 100) {
            result.append('0');
        }
        if (year < 10) {
            result.append('0');
        }
        result.append(year);
        if (m2 < 10) {
            result.append('0');
        }
        result.append(m2);
        if (day < 10) {
            result.append('0');
        }
        result.append(day);
        return result.toString();
    }

    public String getAccessibilityDescription() {
        return RenderUtil.encodeForHtml(this.htmlbDateNavigator.getAccessibilityDescription());
    }

    private class DateNavigatorDay
    implements IDateNavigatorDay {
        private String id = null;
        private String dayId = null;
        private DateNavigatorDayDesign dayDesign = null;
        private int dayNumber = 0;
        private String dayTooltip;
        private int month = 0;
        private int year = 0;
        private boolean isToday = false;

        public DateNavigatorDay(String id, int dayNumber, DateNavigatorDayDesign dayDesign, String dayId, String dayTooltip, int month, int year, boolean isToday) {
            this.id = id;
            this.dayNumber = dayNumber;
            this.dayDesign = dayDesign;
            this.dayId = dayId;
            this.dayTooltip = dayTooltip;
            this.month = month;
            this.year = year;
            this.isToday = isToday;
        }

        public String getId() {
            return this.id;
        }

        public DateNavigatorDayDesign getDesign() {
            return this.dayDesign;
        }

        public String getDayId() {
            return this.dayId;
        }

        public int getDayNr() {
            return this.dayNumber;
        }

        public String getTooltip() {
            if (this.dayTooltip != null) {
                return RenderUtil.encodeForHtml(this.dayTooltip);
            }
            return "";
        }

        public boolean getIsClickable() {
            return true;
        }

        public int getMonthNr() {
            return this.month;
        }

        public int getYear() {
            return this.year;
        }

        public boolean getIsToday() {
            return this.isToday;
        }

        public String getDayDescription() {
            return "";
        }

        public String getDesignDescription() {
            return "";
        }
    }

    private class DateNavigatorWeek
    implements IDateNavigatorWeek {
        private String id = null;
        private URCollection days = null;
        private int weekNumber = 0;
        private int year = 0;

        public DateNavigatorWeek(String id, URCollection days, int weekNr, int year) {
            this.id = id;
            this.days = days;
            this.weekNumber = weekNr;
            this.year = year;
        }

        public String getId() {
            return this.id;
        }

        public IURCollection getDays() {
            return this.days;
        }

        public int getWeekNr() {
            return this.weekNumber;
        }

        public boolean getIsClickable() {
            return true;
        }

        public int getYear() {
            return this.year;
        }
    }

    private class DateNavigatorMonth
    implements IDateNavigatorMonth {
        private String id = null;
        private URCollection weeks = null;
        private String monthName = null;
        private int monthNumber = 0;
        private int year = 0;
        private int firstDayOfWeek = 0;

        public DateNavigatorMonth(String id, URCollection weeks, String monthName, int monthNr, int year, int firstDayOfWeek) {
            this.id = id;
            this.weeks = weeks;
            this.monthName = monthName;
            this.monthNumber = monthNr;
            this.year = year;
            this.firstDayOfWeek = firstDayOfWeek;
        }

        public String getId() {
            return this.id;
        }

        public IURCollection getWeeks() {
            return this.weeks;
        }

        public String getMonthName() {
            return this.monthName;
        }

        public int getMonthNr() {
            return this.monthNumber;
        }

        public int getYear() {
            return this.year;
        }

        public int getFirstDayOfWeek() {
            return this.firstDayOfWeek;
        }

        public boolean getIsClickable() {
            return false;
        }
    }

    private class DateNavigatorRow
    implements IDateNavigatorRow {
        private URCollection months = null;
        private String id = null;

        public DateNavigatorRow(String id, URCollection months) {
            this.id = id;
            this.months = months;
        }

        public String getId() {
            return this.id;
        }

        public IURCollection getMonths() {
            return this.months;
        }
    }
}

