/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering.controls;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.BrowserType;
import com.sapportals.htmlb.enum.JavaVersion;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.unifiedrendering.ClientEvent;
import com.sapportals.htmlb.unifiedrendering.IUIElement;
import com.sapportals.htmlb.unifiedrendering.IURCollection;
import com.sapportals.htmlb.unifiedrendering.URCollection;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IAppletContainer;
import com.sapportals.htmlb.unifiedrendering.controlinterface.IAppletContainerParameter;
import com.sapportals.htmlb.unifiedrendering.controls.UrControl;
import com.sapportals.htmlb.unifiedrendering.enum.AppletContainerJavaVersion;
import com.sapportals.htmlb.util.Config;
import java.util.Iterator;

public class AppletContainer
extends UrControl
implements IAppletContainer,
IUIElement {
    private com.sapportals.htmlb.AppletContainer htmlbAppletContainer;
    private IPageContext pc;
    private URCollection parameters = null;

    public AppletContainer(Component component, IPageContext pageContext) {
        if (component instanceof com.sapportals.htmlb.AppletContainer) {
            this.htmlbAppletContainer = (com.sapportals.htmlb.AppletContainer)component;
            this.pc = pageContext;
            this.parameters = new URCollection();
            Iterator keys = this.htmlbAppletContainer.getParameters().keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.parameters.add(new Parameter(key, (String)this.htmlbAppletContainer.getParameters().get(key)));
            }
        }
    }

    public String getId() {
        return this.htmlbAppletContainer.getName();
    }

    public String getWidth() {
        return this.htmlbAppletContainer.getWidth();
    }

    public String getHeight() {
        return this.htmlbAppletContainer.getHeight();
    }

    public String getJavaClass() {
        return this.htmlbAppletContainer.getClassObject();
    }

    public String getLibrary() {
        return this.htmlbAppletContainer.getLibrary();
    }

    public IURCollection getParameters() {
        return this.parameters;
    }

    public AppletContainerJavaVersion getAppletJavaVersion() {
        JavaVersion version = this.htmlbAppletContainer.getJavaVersion();
        if (version != null && !this.pc.getBrowserId().equals(BrowserType.NETSCAPE_7)) {
            if (version == JavaVersion.V13) {
                return AppletContainerJavaVersion.V13;
            }
            if (version == JavaVersion.V14) {
                return AppletContainerJavaVersion.V14;
            }
            return AppletContainerJavaVersion.BROWSER;
        }
        return AppletContainerJavaVersion.BROWSER;
    }

    public String getCodeBase() {
        Config conf = new Config();
        String codebase = "";
        if (this.getAppletJavaVersion().equals(AppletContainerJavaVersion.V14)) {
            codebase = conf.getProperty("codebaseV14");
        } else if (this.getAppletJavaVersion().equals(AppletContainerJavaVersion.V13)) {
            codebase = conf.getProperty("codebaseV13");
        }
        if (codebase == null) {
            codebase = "";
        }
        return codebase;
    }

    public boolean getScriptable() {
        return false;
    }

    public String getJSEventFunction(ClientEvent event, IPageContext pc) {
        if (event == ClientEvent.SKIPCONTAINER) {
            return "sapUrMapi_skip('" + this.getId() + "',event);";
        }
        pc.getLogLocation().debugT("AppletContainer getJsEventFunction: ", "Event " + event.toString() + " not handled");
        return "";
    }

    public Component getHtmlBControl() {
        return this.htmlbAppletContainer;
    }

    public String getTooltip() {
        return this.htmlbAppletContainer.getToolTip();
    }

    private class Parameter
    implements IAppletContainerParameter {
        private String name = null;
        private String value = null;

        public Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

