/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.unifiedrendering;

import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class TagRenderer {
    private static final char QUOTES = '\"';
    private static final char BACKSLASH = '\\';
    private static final char SLASH = '/';
    private static final char TAG_RIGHT_CHAR = '>';
    private static final char TAG_LEFT_CHAR = '<';
    private static final String END_TAG_LEFT_CHARS = "</";
    private static final String NBSP = "&nbsp;";

    public static void writeBeginTag(PrintWriter out, String tagName) {
        out.write(60);
        out.write(tagName);
    }

    public static void writeAttribute(PrintWriter out, String name, String value, boolean encode) {
        if (value != null) {
            int nameLen = name.length();
            int valueLen = value.length();
            char[] chars = new char[nameLen + valueLen + 4];
            chars[0] = 32;
            name.getChars(0, nameLen, chars, 1);
            chars[nameLen + 1] = 61;
            chars[nameLen + 2] = 34;
            value.getChars(0, valueLen, chars, nameLen + 3);
            chars[nameLen + valueLen + 3] = 34;
            out.write(chars, 0, chars.length);
        } else {
            out.write(32);
            out.write(name);
        }
    }

    public static void writeAttribute(PrintWriter out, String name, StringBuffer value, boolean encode) {
        if (value != null) {
            int nameLen = name.length();
            int valueLen = value.length();
            char[] chars = new char[nameLen + valueLen + 4];
            chars[0] = 32;
            name.getChars(0, nameLen, chars, 1);
            chars[nameLen + 1] = 61;
            chars[nameLen + 2] = 34;
            value.getChars(0, valueLen, chars, nameLen + 3);
            chars[nameLen + valueLen + 3] = 34;
            out.write(chars, 0, chars.length);
        } else {
            out.write(32);
            out.write(name);
        }
    }

    public static void writeSpace(PrintWriter out) {
        out.write(NBSP);
    }

    public static void writeTagRightChar(PrintWriter out) {
        out.write(62);
    }

    public static void writeEndTag(PrintWriter out, String tagName) {
        if (!tagName.equalsIgnoreCase("img") && !tagName.equalsIgnoreCase("input")) {
            out.write(END_TAG_LEFT_CHARS);
            out.write(tagName);
            out.write(62);
        }
    }

    public static void writeTag(PrintWriter out, String tagName) {
        out.write(60);
        out.write(tagName);
        out.write(62);
    }

    public static String translate(String templateId, List paramList, IPageContext manager) {
        Locale currentLocale = manager.getLocale();
        ResourceBundle messages = manager.getResourceBundle("com.sapportals.htmlb.Localization", currentLocale);
        String template = "";
        String result = null;
        try {
            template = messages.getString(templateId.substring(1));
        }
        catch (MissingResourceException ex) {
            template = "";
            manager.getLogLocation().debugT("Please maintain text for key " + templateId);
        }
        if (paramList.size() > 0) {
            int i = 0;
            while (i < paramList.size()) {
                String itemStr;
                if (paramList.get(i) == null) {
                    paramList.set(i, "");
                }
                if ((itemStr = paramList.get(i).toString()).startsWith("#")) {
                    try {
                        paramList.set(i, RenderUtil.encodeForHtml(messages.getString(itemStr.substring(1)), true));
                    }
                    catch (MissingResourceException ex) {
                        paramList.set(i, "");
                        manager.getLogLocation().debugT("Please maintain text for key " + itemStr);
                    }
                }
                ++i;
            }
            Object[] messageArguments = paramList.toArray();
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(currentLocale);
            formatter.applyPattern(template);
            result = formatter.format(messageArguments);
        } else {
            result = RenderUtil.encodeForHtml(template, true);
        }
        if (result.indexOf(123) > -1 && result.indexOf(125) > -1) {
            manager.getLogLocation().debugT("Found more placeholders than params", templateId);
            result = TagRenderer.removePlaceHolders(result);
        }
        return result;
    }

    public static void translate(PrintWriter out, String templateId, List paramList, IPageContext manager) {
        out.write(TagRenderer.translate(templateId, paramList, manager));
    }

    private static String removePlaceHolders(String x) {
        StringBuffer b = new StringBuffer(x.length());
        int pos = 0;
        int last = 0;
        boolean next = false;
        while (pos > -1) {
            if ((pos = x.indexOf(123, pos)) > -1) {
                b.append(x.substring(last, pos));
                pos = x.indexOf(125, pos);
                last = pos + 1;
                continue;
            }
            b.append(x.substring(last));
        }
        return b.toString();
    }
}

