/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.type;

import com.sapportals.htmlb.enum.DataType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;

public class TypeFormatter {
    static HashMap formatters;

    public static void registerFormat(Locale locale, DataType type, Object format) {
        TypeFormatter.registerFormat(locale, type, null, format);
    }

    public static void registerFormat(Locale locale, DataType type, String formatKey, Object format) {
        if (formatters == null) {
            formatters = new HashMap(20);
        }
        String typeString = type.getStringValue();
        if (locale != null) {
            String country = locale.getCountry();
            String language = locale.getLanguage();
            String key = "_" + language + "_" + typeString;
            if (formatKey != null) {
                key = formatKey + key;
            }
            formatters.put(key, format);
            key = country + key;
            formatters.put(key, format);
        } else {
            String key = formatKey == null ? "*" + typeString : formatKey + "*" + typeString;
            formatters.put(key, format);
        }
    }

    public static Object getFormat(Locale locale, DataType type) {
        DateFormat dateFormatter = DateFormat.getDateInstance(3, locale);
        if (type == DataType.DATE) {
            SimpleDateFormat f = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
            StringBuffer pattern = new StringBuffer(f.toPattern());
            if (pattern.toString().indexOf("yy") >= 0 && pattern.toString().indexOf("yyyy") < 0) {
                pattern.replace(pattern.toString().indexOf("yy"), pattern.toString().indexOf("yy") + 2, "yyyy");
                f.applyPattern(pattern.toString());
            }
            return f;
        }
        return TypeFormatter.getFormat(locale, null, type);
    }

    public static Object getFormat(Locale locale, String formatKey, DataType type) {
        Object result = null;
        if (formatters != null) {
            String country = locale.getCountry();
            String language = locale.getLanguage();
            String typeString = type.getStringValue();
            String key = "_" + language + "_" + typeString;
            if (formatKey != null) {
                key = formatKey + key;
            }
            if ((result = formatters.get(key)) == null && (result = formatters.get(key = country + key)) == null) {
                key = formatKey == null ? "*" + typeString : formatKey + "*" + typeString;
                result = formatters.get(key);
            }
        }
        return result;
    }

    static {
        TypeFormatter.registerFormat(null, DataType.DATE, new SimpleDateFormat("yyyy-MM-dd"));
        TypeFormatter.registerFormat(Locale.GERMAN, DataType.DATE, new SimpleDateFormat("dd.MM.yyyy"));
        TypeFormatter.registerFormat(Locale.FRANCE, DataType.DATE, new SimpleDateFormat("dd.MM.yyyy"));
        TypeFormatter.registerFormat(Locale.ITALY, DataType.DATE, new SimpleDateFormat("dd.MM.yyyy"));
        TypeFormatter.registerFormat(Locale.US, DataType.DATE, new SimpleDateFormat("MM/dd/yyyy"));
        TypeFormatter.registerFormat(Locale.UK, DataType.DATE, new SimpleDateFormat("MM/dd/yyyy"));
        TypeFormatter.registerFormat(null, DataType.TIME, new SimpleDateFormat("HH:mm:ss"));
        TypeFormatter.registerFormat(null, DataType.TIME, "SHORT", new SimpleDateFormat("HH:mm"));
    }
}

