/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.type;

import com.sapportals.htmlb.util.Log;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;

public class Time
implements Comparable,
Serializable {
    int hour;
    int minute;
    int second;
    boolean valid = true;

    public Time() {
        GregorianCalendar currentDate = new GregorianCalendar();
        this.set(currentDate.get(11), currentDate.get(12), currentDate.get(13));
    }

    public Time(int hour, int minute, int second) {
        this.set(hour, minute, second);
    }

    public Time(long millisSinceEpoch) {
        this.set(millisSinceEpoch);
    }

    public Time(String timeString) {
        this.set(timeString);
    }

    public void set(long millisSinceEpoch) {
        this.set(new Date(millisSinceEpoch));
    }

    public void set(Date utilDate) {
        GregorianCalendar date = new GregorianCalendar();
        date.setTime(utilDate);
        this.set(date.get(11), date.get(12), date.get(13));
    }

    public void set(String timeString) {
        int hour = -1;
        int minute = -1;
        int second = -1;
        try {
            if (timeString.indexOf(58) >= 0) {
                int sep1 = timeString.indexOf(58);
                int sep2 = timeString.lastIndexOf(58);
                hour = Integer.parseInt(timeString.substring(0, sep1));
                if (sep1 != sep2) {
                    minute = Integer.parseInt(timeString.substring(sep1 + 1, sep2));
                    second = Integer.parseInt(timeString.substring(sep2 + 1));
                } else {
                    minute = Integer.parseInt(timeString.substring(sep1 + 1));
                    second = 0;
                }
            } else if (timeString.length() == 6) {
                hour = Integer.parseInt(timeString.substring(0, 2));
                minute = Integer.parseInt(timeString.substring(2, 4));
                second = Integer.parseInt(timeString.substring(4));
            }
        }
        catch (NumberFormatException e) {
            Log.getLogLocation(false).debugT("Time", "set" + e.getMessage());
        }
        this.set(hour, minute, second);
    }

    private void set(int hour, int minute, int second) {
        try {
            if (hour < 0 || hour > 23) {
                throw new IllegalArgumentException("Argument hour=" + hour + " out of range.");
            }
            if (minute < 0 || minute > 59) {
                throw new IllegalArgumentException("Argument minute=" + minute + " out of range.");
            }
            if (second < 0 || second > 59) {
                throw new IllegalArgumentException("Argument second=" + second + " out of range.");
            }
            this.hour = hour;
            this.minute = minute;
            this.second = second;
        }
        catch (Exception e) {
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
            this.valid = false;
        }
    }

    public String toString() {
        return "" + (this.hour < 10 ? "0" : "") + this.hour + ":" + (this.minute < 10 ? "0" : "") + this.minute + ":" + (this.second < 10 ? "0" : "") + this.second;
    }

    public boolean equals(Object timeObject) {
        if (!(timeObject instanceof Time)) {
            return false;
        }
        return this.compareTo(timeObject) == 0;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (o == null) {
            throw new ClassCastException("Given time must not be null");
        }
        Time that = (Time)o;
        if (!this.isValid()) {
            return -2;
        }
        if (!that.isValid()) {
            return -3;
        }
        if (this.hour < that.hour) {
            return -1;
        }
        if (this.hour > that.hour) {
            return 1;
        }
        if (this.minute < that.minute) {
            return -1;
        }
        if (this.minute > that.minute) {
            return 1;
        }
        if (this.second < that.second) {
            return -1;
        }
        if (this.second > that.second) {
            return 1;
        }
        return 0;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public Date getUtilDate() {
        return new GregorianCalendar(1970, 0, 1, this.hour, this.minute, this.second).getTime();
    }

    public boolean isValid() {
        return this.valid;
    }
}

