/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.type;

import com.sap.mw.jco.IMetaData;
import com.sap.mw.jco.JCO;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataBCD;
import com.sapportals.htmlb.type.DataDate;
import com.sapportals.htmlb.type.DataInteger;
import com.sapportals.htmlb.type.DataString;
import com.sapportals.htmlb.type.DataTime;
import java.util.Date;

public class JCOTypeUtil {
    public static AbstractDataType convertJCOFieldToDataType(JCO.Field field) {
        switch (field.getType()) {
            case 6: {
                DataBCD result = new DataBCD(field.getString());
                result.fixedDecimals = field.getLength();
                result.localeSpecific = false;
                return result;
            }
            case 2: {
                return new DataBCD(field.getBigDecimal());
            }
            case 7: {
                return new DataBCD(field.getDouble());
            }
            case 1: {
                Date date = field.getDate();
                if (date != null) {
                    return new DataDate(date);
                }
                return new DataDate();
            }
            case 0: 
            case 4: 
            case 29: 
            case 30: {
                return new DataString(field.getString());
            }
            case 3: {
                Date time = field.getTime();
                if (time != null) {
                    return new DataTime(time);
                }
                return new DataTime();
            }
            case 8: 
            case 9: 
            case 10: {
                return new DataInteger(field.getInt());
            }
        }
        return null;
    }

    public static void putDataTypeIntoJCOField(AbstractDataType data, JCO.Field field) {
    }

    public static AbstractDataType convertJCOFieldToDataType(JCO.Field field, IMetaData metaData, int i) {
        switch (field.getType()) {
            case 6: {
                DataBCD result = new DataBCD();
                result.fixedDecimals = metaData.getLength(i);
                result.localeSpecific = false;
                return result;
            }
            case 2: {
                return new DataBCD();
            }
            case 7: {
                return new DataBCD();
            }
            case 1: {
                return new DataDate();
            }
            case 0: 
            case 4: 
            case 29: 
            case 30: {
                return new DataString();
            }
            case 3: {
                return new DataTime();
            }
            case 8: 
            case 9: 
            case 10: {
                return new DataInteger();
            }
        }
        return null;
    }
}

